/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.logger;

import android.support.annotation.NonNull;
import com.orhanobut.logger.LogPrintStyle;
import com.orhanobut.logger.LogPrinter;
import com.orhanobut.logger.PrintStyle;
import com.orhanobut.logger.Settings;
import com.orhanobut.logger.util.ObjParser;
import com.orhanobut.logger.util.XmlJsonParser;
import timber.log.Timber;

public class Logger {
    public static final int STACK_OFFSET = 9;
    private static LogPrinter printer;

    protected Logger() {
    }

    public static void initialize(Settings settings) {
        PrintStyle style = settings.style;
        if (style == null) {
            style = new LogPrintStyle();
            settings.setStyle(style);
        }
        printer = new LogPrinter(settings);
        style.setPrinter(printer);
        Timber.plant((Timber.Tree)printer);
    }

    public static Settings getSettings() {
        return printer.getSettings();
    }

    public static Timber.Tree t(String tag) {
        return Timber.tag((String)tag);
    }

    public static void v(String message, Object ... args) {
        message = Logger.handleNullMsg(message);
        Timber.v((String)message, (Object[])args);
    }

    public static void d(String message, Object ... args) {
        message = Logger.handleNullMsg(message);
        Timber.d((String)message, (Object[])args);
    }

    public static void i(String message, Object ... args) {
        message = Logger.handleNullMsg(message);
        Timber.i((String)message, (Object[])args);
    }

    public static void w(String message, Object ... args) {
        message = Logger.handleNullMsg(message);
        Timber.w((String)message, (Object[])args);
    }

    public static void w(Throwable throwable, String message, Object ... args) {
        message = Logger.handleNullMsg(message);
        Timber.w((Throwable)throwable, (String)message, (Object[])args);
    }

    public static void e(String message, Object ... args) {
        message = Logger.handleNullMsg(message);
        Timber.e((String)message, (Object[])args);
    }

    public static void e(Throwable throwable, String message, Object ... args) {
        message = Logger.handleNullMsg(message);
        Timber.e((Throwable)throwable, (String)message, (Object[])args);
    }

    public static void json(String json) {
        Timber.d((String)XmlJsonParser.json(json), (Object[])new Object[0]);
    }

    public static void xml(String xml) {
        Timber.d((String)XmlJsonParser.xml(xml), (Object[])new Object[0]);
    }

    public static void object(Object object) {
        Timber.d((String)ObjParser.parseObj(object), (Object[])new Object[0]);
    }

    public static void plant(Timber.Tree tree) {
        Timber.plant((Timber.Tree)tree);
    }

    public static void uprootAll() {
        Timber.uprootAll();
    }

    @NonNull
    private static String handleNullMsg(String message) {
        if (message == null) {
            message = "null";
        }
        return message;
    }
}

