/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.logger;

import android.support.annotation.NonNull;
import com.orhanobut.logger.PrintStyle;
import com.orhanobut.logger.Settings;
import timber.log.Timber;

public final class LogPrinter
extends Timber.DebugTree {
    private PrintStyle style;
    private boolean isCustomTag = true;
    private final Settings settings;
    private static final String PROPERTY = System.getProperty("line.separator");

    LogPrinter(Settings settings) {
        this.settings = settings;
        this.style = settings.style;
    }

    protected String createStackElementTag(StackTraceElement ignored) {
        this.isCustomTag = false;
        int offset = 9 + this.settings.methodOffset - 1;
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        int length = stackTrace.length;
        return super.createStackElementTag(length > offset ? stackTrace[offset] : stackTrace[stackTrace.length - 1]);
    }

    protected void log(int priority, String tag, @NonNull String message, Throwable ignored) {
        if (this.style.beforePrint() != null) {
            super.log(priority, tag, this.style.beforePrint(), null);
        }
        String[] lines = message.split(PROPERTY);
        int length = lines.length;
        for (int i = 0; i < length; ++i) {
            String logStr = this.style.printLog(lines[i], i, length);
            super.log(priority, tag, logStr, null);
        }
        if (this.style.afterPrint() != null) {
            super.log(priority, tag, this.style.afterPrint(), null);
        }
        this.isCustomTag = true;
    }

    protected boolean isLoggable(String tag, int priority) {
        return priority >= this.settings.priority;
    }

    public boolean isCustomTag() {
        return this.isCustomTag;
    }

    public Settings getSettings() {
        return this.settings;
    }
}

