/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.logger.util;

import android.util.Pair;
import com.orhanobut.logger.util.ArrayParser;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ObjParser {
    private static final String NULL = "null";
    private static final String[] TYPES = new String[]{"int", "java.lang.String", "boolean", "char", "float", "double", "long", "short", "byte"};

    public static String parseObj(Object object) {
        if (object == null) {
            return NULL;
        }
        String simpleName = object.getClass().getSimpleName();
        if (object.getClass().isArray()) {
            StringBuilder msg = new StringBuilder("Temporarily not support more than two dimensional Array!");
            int dim = ArrayParser.getArrayDimension(object);
            switch (dim) {
                case 1: {
                    Pair pair = ArrayParser.arrayToString(object);
                    msg = new StringBuilder(simpleName.replace("[]", "[" + pair.first + "] {\n"));
                    msg.append(pair.second).append("\n");
                    break;
                }
                case 2: {
                    Pair<Pair<Integer, Integer>, String> pair1 = ArrayParser.arrayToObject(object);
                    Pair pair2 = (Pair)pair1.first;
                    msg = new StringBuilder(simpleName.replace("[][]", "[" + pair2.first + "][" + pair2.second + "] {\n"));
                    msg.append(pair1.second).append("\n");
                    break;
                }
            }
            return msg + "}";
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            String msg = "%s size = %d [\n";
            msg = String.format(Locale.ENGLISH, msg, simpleName, collection.size());
            if (!collection.isEmpty()) {
                Iterator iterator = collection.iterator();
                int flag = 0;
                while (iterator.hasNext()) {
                    String itemString = "[%d]:%s%s";
                    Object item = iterator.next();
                    msg = msg + String.format(Locale.ENGLISH, itemString, flag, ObjParser.objectToString(item), flag++ < collection.size() - 1 ? ",\n" : "\n");
                }
            }
            return msg + "\n]";
        }
        if (object instanceof Map) {
            String msg = simpleName + " {\n";
            Map map = (Map)object;
            Set keys = map.keySet();
            for (Object key : keys) {
                String itemString = "[%s -> %s]\n";
                Object value = map.get(key);
                msg = msg + String.format(itemString, ObjParser.objectToString(key), ObjParser.objectToString(value));
            }
            return msg + "}";
        }
        return ObjParser.objectToString(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> String objectToString(T object) {
        if (object == null) {
            return "Object{object is null}";
        }
        if (object.toString().startsWith(object.getClass().getName() + "@")) {
            Field[] fields;
            StringBuilder builder = new StringBuilder(object.getClass().getSimpleName() + "{");
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                boolean flag = false;
                for (String type : TYPES) {
                    if (!field.getType().getName().equalsIgnoreCase(type)) continue;
                    flag = true;
                    Object value = null;
                    try {
                        value = field.get(object);
                    }
                    catch (IllegalAccessException e) {
                        try {
                            value = e;
                        }
                        catch (Throwable throwable) {
                            builder.append(String.format("%s=%s, ", field.getName(), value == null ? NULL : value.toString()));
                            throw throwable;
                        }
                        builder.append(String.format("%s=%s, ", field.getName(), value == null ? NULL : value.toString()));
                        continue;
                    }
                    builder.append(String.format("%s=%s, ", field.getName(), value == null ? NULL : value.toString()));
                }
                if (flag) continue;
                builder.append(String.format("%s=%s, ", field.getName(), "Object"));
            }
            return builder.replace(builder.length() - 2, builder.length() - 1, "}").toString();
        }
        return object.toString();
    }
}

