/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.logger;

import android.support.annotation.NonNull;
import com.orhanobut.logger.Settings;
import timber.log.Timber;

public final class LogPrinter
extends Timber.DebugTree {
    private static final int STACK_OFFSET = 8;
    private static final String BOTTOM_BORDER = "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String PREFIX_BORDER = "\u2551";
    private boolean isCustomTag = true;
    private final StringBuilder sb = new StringBuilder();
    private final Settings settings;
    private static final String PROPERTY = System.getProperty("line.separator");
    private static final int MIN_STACK_OFFSET = 3;

    public LogPrinter(Settings settings) {
        this.settings = settings;
    }

    protected String createStackElementTag(StackTraceElement ignored) {
        this.isCustomTag = false;
        int offset = 8 + this.settings.methodOffset - 1;
        return super.createStackElementTag(new Throwable().getStackTrace()[offset]);
    }

    protected void log(int priority, String tag, @NonNull String message, Throwable ignored) {
        String[] lines = message.split(PROPERTY);
        int length = lines.length;
        for (int i = 0; i < length; ++i) {
            if (i == length - 1) {
                super.log(priority, tag, PREFIX_BORDER + lines[i] + this.getTail(), null);
                continue;
            }
            super.log(priority, tag, PREFIX_BORDER + lines[i], null);
        }
        super.log(priority, tag, BOTTOM_BORDER, null);
        this.isCustomTag = true;
    }

    private String getTail() {
        if (!this.settings.showMethodLink) {
            return "";
        }
        int index = 8 + this.settings.methodOffset + 1;
        if (this.isCustomTag) {
            index -= 2;
        }
        StackTraceElement stack = Thread.currentThread().getStackTrace()[index];
        this.sb.delete(0, this.sb.length());
        this.sb.append(String.format(" ==> %s(%s:%s)", stack.getMethodName(), stack.getFileName(), stack.getLineNumber()));
        if (this.settings.showThreadInfo) {
            this.sb.append(" Thread: ").append(Thread.currentThread().getName());
        }
        return this.sb.toString();
    }

    protected boolean isLoggable(int priority) {
        return priority >= this.settings.priority;
    }

    public Settings getSettings() {
        return this.settings;
    }
}

