/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.logger;

import android.support.annotation.IntRange;
import com.orhanobut.logger.LogLevel;

public final class Settings {
    protected int methodCount = 1;
    protected boolean showThreadInfo = false;
    protected int methodOffset = 0;
    protected boolean isSmartTag = false;
    protected LogLevel logLevel = LogLevel.FULL;

    public Settings setMethodCount(@IntRange(from=0L) int methodCount) {
        this.methodCount = methodCount < 0 ? 0 : methodCount;
        return this;
    }

    Settings(int methodCount, boolean showThreadInfo, int methodOffset, boolean isSmartTag, LogLevel logLevel) {
        this.methodCount = methodCount;
        this.showThreadInfo = showThreadInfo;
        this.methodOffset = methodOffset;
        this.isSmartTag = isSmartTag;
        this.logLevel = logLevel;
    }

    public static SettingsBuilder builder() {
        return new SettingsBuilder();
    }

    public static class SettingsBuilder {
        private int methodCount;
        private boolean showThreadInfo;
        private int methodOffset;
        private boolean isSmartTag;
        private LogLevel logLevel;

        SettingsBuilder() {
        }

        public SettingsBuilder methodCount(int methodCount) {
            this.methodCount = methodCount;
            return this;
        }

        public SettingsBuilder showThreadInfo(boolean showThreadInfo) {
            this.showThreadInfo = showThreadInfo;
            return this;
        }

        public SettingsBuilder methodOffset(int methodOffset) {
            this.methodOffset = methodOffset;
            return this;
        }

        public SettingsBuilder isSmartTag(boolean isSmartTag) {
            this.isSmartTag = isSmartTag;
            return this;
        }

        public SettingsBuilder logLevel(LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Settings build() {
            return new Settings(this.methodCount, this.showThreadInfo, this.methodOffset, this.isSmartTag, this.logLevel);
        }

        public String toString() {
            return "Settings.SettingsBuilder(methodCount=" + this.methodCount + ", showThreadInfo=" + this.showThreadInfo + ", methodOffset=" + this.methodOffset + ", isSmartTag=" + this.isSmartTag + ", logLevel=" + (Object)((Object)this.logLevel) + ")";
        }
    }
}

