/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.logger;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.orhanobut.logger.LogLevel;
import com.orhanobut.logger.Logger;
import com.orhanobut.logger.Settings;
import com.orhanobut.logger.util.ObjParser;
import com.orhanobut.logger.util.XmlJsonParser;
import java.util.MissingFormatArgumentException;

public final class LogPrinter {
    private static final int CHUNK_SIZE = 4000;
    private static final int MIN_STACK_OFFSET = 3;
    private static final String BOTTOM_BORDER = "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    public static final String TAG = "PRETTYLOGGER";
    private final Settings settings;
    private static final ThreadLocal<String> LOCAL_TAG = new ThreadLocal();
    private static final ThreadLocal<Integer> LOCAL_METHOD_COUNT = new ThreadLocal();

    public LogPrinter(Settings settings) {
        this.settings = settings;
    }

    public LogPrinter t(String tag, int methodCount) {
        if (tag != null) {
            LOCAL_TAG.set(tag);
        }
        LOCAL_METHOD_COUNT.set(methodCount);
        return this;
    }

    public void v(@Nullable String message, Object ... args) {
        this.log(2, message, args);
    }

    public void d(@Nullable String message, Object ... args) {
        this.log(3, message, args);
    }

    public void i(@Nullable String message, Object ... args) {
        this.log(4, message, args);
    }

    public void w(String message, Object ... args) {
        this.log(5, message, args);
    }

    public void e(@Nullable String message, Object ... args) {
        this.e(null, message, args);
    }

    public void e(Throwable throwable, @Nullable String message, Object ... args) {
        if (throwable != null && message != null) {
            message = message + " : " + throwable.toString();
        }
        if (throwable != null && message == null) {
            message = throwable.toString();
        }
        if (message == null) {
            message = "No message/exception is set";
        }
        this.log(6, message, args);
    }

    public void json(@Nullable String json) {
        this.d(XmlJsonParser.json(json), new Object[0]);
    }

    public void xml(String xml) {
        this.d(XmlJsonParser.xml(xml), new Object[0]);
    }

    public void object(@Nullable Object object) {
        this.d(ObjParser.parseObj(object), new Object[0]);
    }

    private synchronized void log(int logType, @Nullable String msg, Object ... args) {
        if (this.settings.logLevel == LogLevel.NONE) {
            return;
        }
        String tag = this.formatTag();
        byte[] bytes = (msg = this.formatMsg(msg, args)).getBytes();
        int length = bytes.length;
        if (length <= 4000) {
            this.logContent(logType, tag, msg);
        } else {
            for (int i = 0; i < length; i += 4000) {
                int count = Math.min(length - i, 4000);
                this.logContent(logType, tag, new String(bytes, i, count));
            }
        }
        this.printLog(logType, tag, BOTTOM_BORDER);
    }

    private String formatMsg(@Nullable String msg, Object[] args) {
        if (msg != null) {
            try {
                msg = args.length == 0 ? msg : String.format(msg, args);
            }
            catch (MissingFormatArgumentException e) {
                e.printStackTrace();
            }
        } else {
            msg = "null";
        }
        return msg;
    }

    private void logContent(int logType, String tag, String chunk) {
        String[] lines = chunk.split(System.getProperty("line.separator"));
        int length = lines.length;
        for (int i = 0; i < length; ++i) {
            if (i == length - 1) {
                this.printLog(logType, tag, "\u2551" + lines[i] + this.getTail());
                continue;
            }
            this.printLog(logType, tag, "\u2551" + lines[i]);
        }
    }

    private String getTail() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        int stackOffset = this.getStackOffset(trace) + this.settings.methodOffset;
        int methodCount = this.getMethodCount();
        if (methodCount + stackOffset > trace.length) {
            methodCount = trace.length - stackOffset - 1;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = methodCount; i > 0; --i) {
            int stackIndex = i + stackOffset;
            if (stackIndex >= trace.length) continue;
            sb.append(" ==> ").append(trace[stackIndex].getMethodName()).append("(").append(trace[stackIndex].getFileName()).append(":").append(trace[stackIndex].getLineNumber()).append(")");
        }
        if (this.settings.showThreadInfo) {
            sb.append(" Thread: ").append(Thread.currentThread().getName());
        }
        return sb.toString();
    }

    private void printLog(int logType, String tag, String msg) {
        switch (logType) {
            case 6: {
                Log.e((String)tag, (String)msg);
                break;
            }
            case 4: {
                Log.i((String)tag, (String)msg);
                break;
            }
            case 2: {
                Log.v((String)tag, (String)msg);
                break;
            }
            case 5: {
                Log.w((String)tag, (String)msg);
                break;
            }
            case 7: {
                Log.wtf((String)tag, (String)msg);
                break;
            }
            default: {
                Log.d((String)tag, (String)msg);
            }
        }
    }

    private String getCurrentClassName() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        int offset = this.getStackOffset(trace) + this.settings.methodOffset;
        StackTraceElement thisMethodStack = new Exception().getStackTrace()[offset - 1];
        String result = thisMethodStack.getClassName();
        int lastIndex = result.lastIndexOf(".");
        result = result.substring(lastIndex + 1, result.length());
        return result;
    }

    @NonNull
    private String getTag() {
        String tag = LOCAL_TAG.get();
        if (tag != null) {
            LOCAL_TAG.remove();
            return tag;
        }
        return TAG;
    }

    private String formatTag() {
        String tag = this.getTag();
        if (this.settings.isSmartTag) {
            if (TAG.equals(tag)) {
                return this.getCurrentClassName();
            }
            return this.getCurrentClassName() + "-" + tag;
        }
        return tag;
    }

    private int getMethodCount() {
        Integer count = LOCAL_METHOD_COUNT.get();
        int result = this.settings.methodCount;
        if (count != null) {
            LOCAL_METHOD_COUNT.remove();
            result = count;
        }
        if (result < 0) {
            throw new IllegalStateException("methodCount cannot be negative");
        }
        return result;
    }

    private int getStackOffset(StackTraceElement[] trace) {
        for (int i = 3; i < trace.length; ++i) {
            StackTraceElement e = trace[i];
            String name = e.getClassName();
            if (name.equals(LogPrinter.class.getName()) || name.equals(Logger.class.getName())) continue;
            return --i;
        }
        return -1;
    }

    public Settings getSettings() {
        return this.settings;
    }
}

