/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.logger;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.orhanobut.logger.LogLevel;
import com.orhanobut.logger.Logger;
import com.orhanobut.logger.Printer;
import com.orhanobut.logger.Settings;
import com.orhanobut.logger.util.ArrayUtil;
import com.orhanobut.logger.util.ObjectUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class LoggerPrinter
implements Printer {
    private static final int CHUNK_SIZE = 4000;
    private static final int JSON_INDENT = 4;
    private static final int MIN_STACK_OFFSET = 3;
    private static final String BOTTOM_BORDER = "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    public static final String TAG = "PRETTYLOGGER";
    private final Settings settings;
    private static final ThreadLocal<String> LOCAL_TAG = new ThreadLocal();
    private static final ThreadLocal<Integer> LOCAL_METHOD_COUNT = new ThreadLocal();

    public LoggerPrinter(Settings settings) {
        this.settings = settings;
    }

    @Override
    public Printer t(String tag, int methodCount) {
        if (tag != null) {
            LOCAL_TAG.set(tag);
        }
        LOCAL_METHOD_COUNT.set(methodCount);
        return this;
    }

    @Override
    public void v(@Nullable String message, Object ... args) {
        this.log(2, message, args);
    }

    @Override
    public void d(@Nullable String message, Object ... args) {
        this.log(3, message, args);
    }

    @Override
    public void i(@Nullable String message, Object ... args) {
        this.log(4, message, args);
    }

    @Override
    public void w(String message, Object ... args) {
        this.log(5, message, args);
    }

    @Override
    public void e(@Nullable String message, Object ... args) {
        this.e(null, message, args);
    }

    @Override
    public void e(Throwable throwable, @Nullable String message, Object ... args) {
        if (throwable != null && message != null) {
            message = message + " : " + throwable.toString();
        }
        if (throwable != null && message == null) {
            message = throwable.toString();
        }
        if (message == null) {
            message = "No message/exception is set";
        }
        this.log(6, message, args);
    }

    @Override
    public void json(@Nullable String json) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.d("Empty/Null json content.(This msg from logger)", new Object[0]);
            return;
        }
        try {
            if (json.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(json);
                String message = jsonObject.toString(4);
                this.d(message, new Object[0]);
                return;
            }
            if (json.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(json);
                String message = jsonArray.toString(4);
                this.d(message, new Object[0]);
            }
        }
        catch (JSONException e) {
            this.e(e.getCause().getMessage() + "\n" + json, new Object[0]);
        }
    }

    @Override
    public void xml(String xml) {
        if (TextUtils.isEmpty((CharSequence)xml)) {
            this.d("Empty/Null xml content.(This msg from logger)", new Object[0]);
            return;
        }
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlInput, xmlOutput);
            this.d(xmlOutput.getWriter().toString().replaceFirst(">", ">\n"), new Object[0]);
        }
        catch (TransformerException e) {
            this.e(e.getCause().getMessage() + "\n" + xml, new Object[0]);
        }
    }

    @Override
    public void object(@Nullable Object object) {
        if (object == null) {
            this.d("null", new Object[0]);
            return;
        }
        String simpleName = object.getClass().getSimpleName();
        if (object.getClass().isArray()) {
            StringBuilder msg = new StringBuilder("Temporarily not support more than two dimensional Array!");
            int dim = ArrayUtil.getArrayDimension(object);
            switch (dim) {
                case 1: {
                    Pair pair = ArrayUtil.arrayToString(object);
                    msg = new StringBuilder(simpleName.replace("[]", "[" + pair.first + "] {\n"));
                    msg.append(pair.second).append("\n");
                    break;
                }
                case 2: {
                    Pair<Pair<Integer, Integer>, String> pair1 = ArrayUtil.arrayToObject(object);
                    Pair pair2 = (Pair)pair1.first;
                    msg = new StringBuilder(simpleName.replace("[][]", "[" + pair2.first + "][" + pair2.second + "] {\n"));
                    msg.append(pair1.second).append("\n");
                    break;
                }
            }
            this.d(msg + "}", new Object[0]);
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            String msg = "%s size = %d [\n";
            msg = String.format(Locale.ENGLISH, msg, simpleName, collection.size());
            if (!collection.isEmpty()) {
                Iterator iterator = collection.iterator();
                int flag = 0;
                while (iterator.hasNext()) {
                    String itemString = "[%d]:%s%s";
                    Object item = iterator.next();
                    msg = msg + String.format(Locale.ENGLISH, itemString, flag, ObjectUtil.objectToString(item), flag++ < collection.size() - 1 ? ",\n" : "\n");
                }
            }
            this.d(msg + "\n]", new Object[0]);
        } else if (object instanceof Map) {
            String msg = simpleName + " {\n";
            Map map = (Map)object;
            Set keys = map.keySet();
            for (Object key : keys) {
                String itemString = "[%s -> %s]\n";
                Object value = map.get(key);
                msg = msg + String.format(itemString, ObjectUtil.objectToString(key), ObjectUtil.objectToString(value));
            }
            this.d(msg + "}", new Object[0]);
        } else {
            this.d(ObjectUtil.objectToString(object), new Object[0]);
        }
    }

    private synchronized void log(int logType, @Nullable String msg, Object ... args) {
        if (this.settings.getLogLevel() == LogLevel.NONE) {
            return;
        }
        String tag = this.formatTag();
        String message = TextUtils.isEmpty((CharSequence)msg) ? "null" : String.format(msg, args);
        byte[] bytes = message.getBytes();
        int length = bytes.length;
        if (length <= 4000) {
            this.logContent(logType, tag, message);
            this.logBottomBorder(logType, tag);
        } else {
            for (int i = 0; i < length; i += 4000) {
                int count = Math.min(length - i, 4000);
                this.logContent(logType, tag, new String(bytes, i, count));
            }
            this.logBottomBorder(logType, tag);
        }
    }

    private void logBottomBorder(int logType, String tag) {
        this.printLog(logType, tag, BOTTOM_BORDER);
    }

    private void logContent(int logType, String tag, String chunk) {
        String[] lines = chunk.split(System.getProperty("line.separator"));
        int length = lines.length;
        for (int i = 0; i < length; ++i) {
            if (i == length - 1) {
                this.printLog(logType, tag, lines[i] + this.getTail());
                continue;
            }
            this.printLog(logType, tag, lines[i]);
        }
    }

    private String getTail() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        int stackOffset = this.getStackOffset(trace) + this.settings.getMethodOffset();
        int methodCount = this.getMethodCount();
        if (methodCount + stackOffset > trace.length) {
            methodCount = trace.length - stackOffset - 1;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = methodCount; i > 0; --i) {
            int stackIndex = i + stackOffset;
            if (stackIndex >= trace.length) continue;
            sb.append(" ==> ").append(trace[stackIndex].getMethodName()).append(" (").append(trace[stackIndex].getFileName()).append(":").append(trace[stackIndex].getLineNumber()).append(")");
        }
        if (this.settings.isShowThreadInfo()) {
            sb.append(" Thread: ").append(Thread.currentThread().getName());
        }
        return sb.toString();
    }

    private void printLog(int logType, String tag, String msg) {
        switch (logType) {
            case 6: {
                Log.e((String)tag, (String)msg);
                break;
            }
            case 4: {
                Log.i((String)tag, (String)msg);
                break;
            }
            case 2: {
                Log.v((String)tag, (String)msg);
                break;
            }
            case 5: {
                Log.w((String)tag, (String)msg);
                break;
            }
            case 7: {
                Log.wtf((String)tag, (String)msg);
                break;
            }
            default: {
                Log.d((String)tag, (String)msg);
            }
        }
    }

    private String getCurrentClassName() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        int offset = this.getStackOffset(trace) + this.settings.getMethodOffset();
        StackTraceElement thisMethodStack = new Exception().getStackTrace()[offset - 1];
        String result = thisMethodStack.getClassName();
        int lastIndex = result.lastIndexOf(".");
        result = result.substring(lastIndex + 1, result.length());
        return result;
    }

    @NonNull
    private String getTag() {
        String tag = LOCAL_TAG.get();
        if (tag != null) {
            LOCAL_TAG.remove();
            return tag;
        }
        return TAG;
    }

    private String formatTag() {
        String tag = this.getTag();
        if (this.settings.isSmartTag()) {
            if (TAG.equals(tag)) {
                return this.getCurrentClassName();
            }
            return this.getCurrentClassName() + "-" + tag;
        }
        return tag;
    }

    private int getMethodCount() {
        Integer count = LOCAL_METHOD_COUNT.get();
        int result = this.settings.getMethodCount();
        if (count != null) {
            LOCAL_METHOD_COUNT.remove();
            result = count;
        }
        if (result < 0) {
            throw new IllegalStateException("methodCount cannot be negative");
        }
        return result;
    }

    private int getStackOffset(StackTraceElement[] trace) {
        for (int i = 3; i < trace.length; ++i) {
            StackTraceElement e = trace[i];
            String name = e.getClassName();
            if (name.equals(LoggerPrinter.class.getName()) || name.equals(Logger.class.getName())) continue;
            return --i;
        }
        return -1;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }
}

