/*
 * Decompiled with CFR 0.152.
 */
package me.weishu.epic.art.arch;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class ShellCode {
    public abstract byte[] createDirectJump(long var1);

    public abstract int sizeOfDirectJump();

    public abstract long toPC(long var1);

    public abstract long toMem(long var1);

    public byte[] createCallOrigin(long originalAddress, byte[] originalPrologue) {
        byte[] callOriginal = new byte[this.sizeOfCallOrigin()];
        System.arraycopy(originalPrologue, 0, callOriginal, 0, this.sizeOfDirectJump());
        byte[] directJump = this.createDirectJump(this.toPC(originalAddress + (long)this.sizeOfDirectJump()));
        System.arraycopy(directJump, 0, callOriginal, this.sizeOfDirectJump(), directJump.length);
        return callOriginal;
    }

    public int sizeOfCallOrigin() {
        return this.sizeOfDirectJump() * 2;
    }

    public abstract int sizeOfBridgeJump();

    public byte[] createBridgeJump(long targetAddress, long targetEntry, long srcAddress, long structAddress) {
        throw new RuntimeException("not impled");
    }

    static void writeInt(int i, ByteOrder order, byte[] target, int pos) {
        System.arraycopy(ByteBuffer.allocate(4).order(order).putInt(i).array(), 0, target, pos, 4);
    }

    static void writeLong(long i, ByteOrder order, byte[] target, int pos) {
        System.arraycopy(ByteBuffer.allocate(8).order(order).putLong(i).array(), 0, target, pos, 8);
    }

    public abstract String getName();
}

