/*
 * Decompiled with CFR 0.152.
 */
package me.weishu.epic.art;

import android.util.Log;
import com.taobao.android.dexposed.DeviceCheck;
import com.taobao.android.dexposed.utility.Debug;
import com.taobao.android.dexposed.utility.Logger;
import com.taobao.android.dexposed.utility.Unsafe;
import de.robv.android.xposed.XposedHelpers;
import java.lang.reflect.Member;

public final class EpicNative {
    private static final String TAG = "EpicNative";
    private static volatile boolean useUnsafe = false;

    public static native long mmap(int var0);

    public static native boolean munmap(long var0, int var2);

    public static native void memcpy(long var0, long var2, int var4);

    public static native void memput(byte[] var0, long var1);

    public static native byte[] memget(long var0, int var2);

    public static native boolean munprotect(long var0, long var2);

    public static native long getMethodAddress(Member var0);

    public static native void MakeInitializedClassVisibilyInitialized(long var0);

    public static native boolean cacheflush(long var0, long var2);

    public static native long malloc(int var0);

    public static native Object getObjectNative(long var0, long var2);

    private static native boolean isGetObjectAvailable();

    public static Object getObject(long self, long address) {
        if (useUnsafe) {
            return Unsafe.getObject(address);
        }
        return EpicNative.getObjectNative(self, address);
    }

    public static native boolean compileMethod(Member var0, long var1);

    public static native long suspendAll();

    public static native void resumeAll(long var0);

    public static native long stopJit();

    public static native void startJit(long var0);

    static native boolean activateNative(long var0, long var2, long var4, long var6, byte[] var8);

    public static native void disableMovingGc(int var0);

    private EpicNative() {
    }

    public static boolean compileMethod(Member method) {
        long nativePeer = XposedHelpers.getLongField((Object)Thread.currentThread(), (String)"nativePeer");
        return EpicNative.compileMethod(method, nativePeer);
    }

    public static Object getObject(long address) {
        long nativePeer = XposedHelpers.getLongField((Object)Thread.currentThread(), (String)"nativePeer");
        return EpicNative.getObject(nativePeer, address);
    }

    public static void MakeInitializedClassVisibilyInitialized() {
        long nativePeer = XposedHelpers.getLongField((Object)Thread.currentThread(), (String)"nativePeer");
        EpicNative.MakeInitializedClassVisibilyInitialized(nativePeer);
    }

    public static long map(int length) {
        long m = EpicNative.mmap(length);
        Logger.i(TAG, "Mapped memory of size " + length + " at " + Debug.addrHex(m));
        return m;
    }

    public static boolean unmap(long address, int length) {
        Logger.d(TAG, "Removing mapped memory of size " + length + " at " + Debug.addrHex(address));
        return EpicNative.munmap(address, length);
    }

    public static void put(byte[] bytes, long dest) {
        EpicNative.memput(bytes, dest);
    }

    public static byte[] get(long src, int length) {
        Logger.d(TAG, "Reading " + length + " bytes from: " + Debug.addrHex(src));
        byte[] bytes = EpicNative.memget(src, length);
        Logger.d(TAG, Debug.hexdump(bytes, src));
        return bytes;
    }

    public static boolean unprotect(long addr, long len) {
        Logger.d(TAG, "Disabling mprotect from " + Debug.addrHex(addr));
        return EpicNative.munprotect(addr, len);
    }

    public static void copy(long src, long dst, int length) {
        Logger.d(TAG, "Copy " + length + " bytes form " + Debug.addrHex(src) + " to " + Debug.addrHex(dst));
        EpicNative.memcpy(src, dst, length);
    }

    static {
        try {
            System.loadLibrary("epic");
            useUnsafe = DeviceCheck.isYunOS() || !EpicNative.isGetObjectAvailable();
            Log.i((String)TAG, (String)("use unsafe ? " + useUnsafe));
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"init EpicNative error", (Throwable)e);
        }
    }
}

