/*
 * Decompiled with CFR 0.152.
 */
package me.weishu.epic.art;

import android.os.Build;
import com.taobao.android.dexposed.utility.Debug;
import com.taobao.android.dexposed.utility.Logger;
import com.taobao.android.dexposed.utility.Runtime;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.weishu.epic.art.EpicNative;
import me.weishu.epic.art.Trampoline;
import me.weishu.epic.art.arch.Arm64;
import me.weishu.epic.art.arch.ShellCode;
import me.weishu.epic.art.arch.Thumb2;
import me.weishu.epic.art.method.ArtMethod;

public final class Epic {
    private static final String TAG = "Epic";
    private static final Map<String, ArtMethod> backupMethodsMapping = new ConcurrentHashMap<String, ArtMethod>();
    private static final Map<Long, MethodInfo> originSigs = new ConcurrentHashMap<Long, MethodInfo>();
    private static final Map<Long, Trampoline> scripts = new HashMap<Long, Trampoline>();
    private static ShellCode ShellCode;

    public static boolean hookMethod(Constructor origin) {
        return Epic.hookMethod(ArtMethod.of(origin));
    }

    public static boolean hookMethod(Method origin) {
        ArtMethod artOrigin = ArtMethod.of(origin);
        return Epic.hookMethod(artOrigin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hookMethod(ArtMethod artOrigin) {
        EntryLock lock;
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.isStatic = Modifier.isStatic(artOrigin.getModifiers());
        Class<?>[] parameterTypes = artOrigin.getParameterTypes();
        if (parameterTypes != null) {
            methodInfo.paramNumber = parameterTypes.length;
            methodInfo.paramTypes = parameterTypes;
        } else {
            methodInfo.paramNumber = 0;
            methodInfo.paramTypes = new Class[0];
        }
        methodInfo.returnType = artOrigin.getReturnType();
        methodInfo.method = artOrigin;
        originSigs.put(artOrigin.getAddress(), methodInfo);
        if (!artOrigin.isAccessible()) {
            artOrigin.setAccessible(true);
        }
        artOrigin.ensureResolved();
        long originEntry = artOrigin.getEntryPointFromQuickCompiledCode();
        if (originEntry == ArtMethod.getQuickToInterpreterBridge()) {
            Logger.i(TAG, "this method is not compiled, compile it now. current entry: 0x" + Long.toHexString(originEntry));
            boolean ret = artOrigin.compile();
            if (ret) {
                originEntry = artOrigin.getEntryPointFromQuickCompiledCode();
                Logger.i(TAG, "compile method success, new entry: 0x" + Long.toHexString(originEntry));
            } else {
                Logger.e(TAG, "compile method failed...");
                return false;
            }
        }
        ArtMethod backupMethod = artOrigin.backup();
        Logger.i(TAG, "backup method address:" + Debug.addrHex(backupMethod.getAddress()));
        Logger.i(TAG, "backup method entry :" + Debug.addrHex(backupMethod.getEntryPointFromQuickCompiledCode()));
        ArtMethod backupList = Epic.getBackMethod(artOrigin);
        if (backupList == null) {
            Epic.setBackMethod(artOrigin, backupMethod);
        }
        long key = originEntry;
        EntryLock entryLock = lock = EntryLock.obtain(originEntry);
        synchronized (entryLock) {
            if (!scripts.containsKey(key)) {
                scripts.put(key, new Trampoline(ShellCode, originEntry));
            }
            Trampoline trampoline = scripts.get(key);
            boolean ret = trampoline.install(artOrigin);
            return ret;
        }
    }

    public static synchronized ArtMethod getBackMethod(ArtMethod origin) {
        String identifier = origin.getIdentifier();
        return backupMethodsMapping.get(identifier);
    }

    public static synchronized void setBackMethod(ArtMethod origin, ArtMethod backup) {
        String identifier = origin.getIdentifier();
        backupMethodsMapping.put(identifier, backup);
    }

    public static MethodInfo getMethodInfo(long address) {
        return originSigs.get(address);
    }

    public static int getQuickCompiledCodeSize(ArtMethod method) {
        long entryPoint = ShellCode.toMem(method.getEntryPointFromQuickCompiledCode());
        long sizeInfo1 = entryPoint - 4L;
        byte[] bytes = EpicNative.get(sizeInfo1, 4);
        int size = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
        Logger.d(TAG, "getQuickCompiledCodeSize: " + size);
        return size;
    }

    static {
        boolean isArm = true;
        int apiLevel = Build.VERSION.SDK_INT;
        boolean thumb2 = true;
        if (isArm) {
            if (Runtime.is64Bit()) {
                ShellCode = new Arm64();
            } else if (Runtime.isThumb2()) {
                ShellCode = new Thumb2();
            } else {
                thumb2 = false;
                ShellCode = new Thumb2();
                Logger.w(TAG, "ARM32, not support now.");
            }
        }
        if (ShellCode == null) {
            throw new RuntimeException("Do not support this ARCH now!! API LEVEL:" + apiLevel + " thumb2 ? : " + thumb2);
        }
        Logger.i(TAG, "Using: " + ShellCode.getName());
    }

    private static class EntryLock {
        static Map<Long, EntryLock> sLockPool = new HashMap<Long, EntryLock>();

        private EntryLock() {
        }

        static synchronized EntryLock obtain(long entry) {
            if (sLockPool.containsKey(entry)) {
                return sLockPool.get(entry);
            }
            EntryLock entryLock = new EntryLock();
            sLockPool.put(entry, entryLock);
            return entryLock;
        }
    }

    public static class MethodInfo {
        public boolean isStatic;
        public int paramNumber;
        public Class<?>[] paramTypes;
        public Class<?> returnType;
        public ArtMethod method;

        public String toString() {
            return this.method.toGenericString();
        }
    }
}

