/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.android.dexposed.utility;

import android.util.Log;
import com.taobao.android.dexposed.utility.Runtime;
import java.lang.reflect.Field;

public final class Unsafe {
    private static final String TAG = "Unsafe";
    private static Object unsafe;
    private static Class unsafeClass;

    private Unsafe() {
    }

    public static int arrayBaseOffset(Class cls) {
        try {
            return (Integer)unsafeClass.getDeclaredMethod("arrayBaseOffset", Class.class).invoke(unsafe, cls);
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
            return 0;
        }
    }

    public static int arrayIndexScale(Class cls) {
        try {
            return (Integer)unsafeClass.getDeclaredMethod("arrayIndexScale", Class.class).invoke(unsafe, cls);
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
            return 0;
        }
    }

    public static long objectFieldOffset(Field field) {
        try {
            return (Long)unsafeClass.getDeclaredMethod("objectFieldOffset", Field.class).invoke(unsafe, field);
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
            return 0L;
        }
    }

    public static int getInt(Object array, long offset) {
        try {
            return (Integer)unsafeClass.getDeclaredMethod("getInt", Object.class, Long.TYPE).invoke(unsafe, array, offset);
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
            return 0;
        }
    }

    public static long getLong(Object array, long offset) {
        try {
            return (Long)unsafeClass.getDeclaredMethod("getLong", Object.class, Long.TYPE).invoke(unsafe, array, offset);
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
            return 0L;
        }
    }

    public static void putLong(Object array, long offset, long value) {
        try {
            unsafeClass.getDeclaredMethod("putLongVolatile", Object.class, Long.TYPE, Long.TYPE).invoke(unsafe, array, offset, value);
        }
        catch (Exception e) {
            try {
                unsafeClass.getDeclaredMethod("putLong", Object.class, Long.TYPE, Long.TYPE).invoke(unsafe, array, offset, value);
            }
            catch (Exception e1) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    public static void putInt(Object array, long offset, int value) {
        try {
            unsafeClass.getDeclaredMethod("putIntVolatile", Object.class, Long.TYPE, Integer.TYPE).invoke(unsafe, array, offset, value);
        }
        catch (Exception e) {
            try {
                unsafeClass.getDeclaredMethod("putIntVolatile", Object.class, Long.TYPE, Integer.TYPE).invoke(unsafe, array, offset, value);
            }
            catch (Exception e1) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    public static long getObjectAddress(Object obj) {
        try {
            Object[] array = new Object[]{obj};
            if (Unsafe.arrayIndexScale(Object[].class) == 8) {
                return Unsafe.getLong(array, Unsafe.arrayBaseOffset(Object[].class));
            }
            return 0xFFFFFFFFL & (long)Unsafe.getInt(array, Unsafe.arrayBaseOffset(Object[].class));
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
            return -1L;
        }
    }

    public static Object getObject(long address) {
        Object[] array = new Object[]{null};
        long baseOffset = Unsafe.arrayBaseOffset(Object[].class);
        if (Runtime.is64Bit()) {
            Unsafe.putLong(array, baseOffset, address);
        } else {
            Unsafe.putInt(array, baseOffset, (int)address);
        }
        return array[0];
    }

    static {
        try {
            unsafeClass = Class.forName("sun.misc.Unsafe");
            Field theUnsafe = unsafeClass.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = theUnsafe.get(null);
        }
        catch (Exception e) {
            try {
                Field theUnsafe = unsafeClass.getDeclaredField("THE_ONE");
                theUnsafe.setAccessible(true);
                unsafe = theUnsafe.get(null);
            }
            catch (Exception e2) {
                Log.w((String)TAG, (String)"Unsafe not found o.O");
            }
        }
    }
}

