/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.android.dexposed.utility;

import com.taobao.android.dexposed.utility.Runtime;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class Platform {
    static Platform PLATFORM_INTERNAL = Runtime.is64Bit() ? new Platform64Bit() : new Platform32Bit();

    public static Platform getPlatform() {
        return PLATFORM_INTERNAL;
    }

    public abstract int orderByteToInt(byte[] var1);

    public abstract long orderByteToLong(byte[] var1);

    public abstract byte[] orderLongToByte(long var1, int var3);

    public abstract byte[] orderIntToByte(int var1);

    public abstract int getIntSize();

    static class Platform64Bit
    extends Platform {
        Platform64Bit() {
        }

        @Override
        public int orderByteToInt(byte[] data) {
            return ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).getInt();
        }

        @Override
        public long orderByteToLong(byte[] data) {
            return ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).getLong();
        }

        @Override
        public byte[] orderLongToByte(long serial, int length) {
            return ByteBuffer.allocate(length).order(ByteOrder.LITTLE_ENDIAN).putLong(serial).array();
        }

        @Override
        public byte[] orderIntToByte(int serial) {
            return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(serial).array();
        }

        @Override
        public int getIntSize() {
            return 8;
        }
    }

    static class Platform32Bit
    extends Platform {
        Platform32Bit() {
        }

        @Override
        public int orderByteToInt(byte[] data) {
            return ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).getInt();
        }

        @Override
        public long orderByteToLong(byte[] data) {
            return (long)ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).getInt() & 0xFFFFFFFFL;
        }

        @Override
        public byte[] orderLongToByte(long serial, int length) {
            return ByteBuffer.allocate(length).order(ByteOrder.LITTLE_ENDIAN).putInt((int)serial).array();
        }

        @Override
        public byte[] orderIntToByte(int serial) {
            return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(serial).array();
        }

        @Override
        public int getIntSize() {
            return 4;
        }
    }
}

