/*
 * Decompiled with CFR 0.152.
 */
package com.yanyusong.y_divideritemdecoration;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.yanyusong.y_divideritemdecoration.Dp2Px;
import com.yanyusong.y_divideritemdecoration.Y_Divider;
import com.yanyusong.y_divideritemdecoration.Y_DividerBuilder;

public abstract class Y_DividerItemDecoration
extends RecyclerView.ItemDecoration {
    private Paint mPaint;
    private Context context;

    public Y_DividerItemDecoration(Context context) {
        this.context = context;
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    public void onDraw(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            int endPaddingPx;
            int startPaddingPx;
            int lineWidthPx;
            View child = parent.getChildAt(i);
            if (!(child.getLayoutParams() instanceof RecyclerView.LayoutParams)) {
                return;
            }
            int itemPosition = ((RecyclerView.LayoutParams)child.getLayoutParams()).getViewLayoutPosition();
            Y_Divider divider = this.getDivider(itemPosition);
            if (divider == null) {
                return;
            }
            if (divider.getLeftSideLine().isHave()) {
                lineWidthPx = Dp2Px.convert(this.context, divider.getLeftSideLine().getWidthDp());
                startPaddingPx = Dp2Px.convert(this.context, divider.getLeftSideLine().getStartPaddingDp());
                endPaddingPx = Dp2Px.convert(this.context, divider.getLeftSideLine().getEndPaddingDp());
                this.drawChildLeftVertical(child, c, divider.getLeftSideLine().getColor(), lineWidthPx, startPaddingPx, endPaddingPx);
            }
            if (divider.getTopSideLine().isHave()) {
                lineWidthPx = Dp2Px.convert(this.context, divider.getTopSideLine().getWidthDp());
                startPaddingPx = Dp2Px.convert(this.context, divider.getTopSideLine().getStartPaddingDp());
                endPaddingPx = Dp2Px.convert(this.context, divider.getTopSideLine().getEndPaddingDp());
                this.drawChildTopHorizontal(child, c, divider.topSideLine.getColor(), lineWidthPx, startPaddingPx, endPaddingPx);
            }
            if (divider.getRightSideLine().isHave()) {
                lineWidthPx = Dp2Px.convert(this.context, divider.getRightSideLine().getWidthDp());
                startPaddingPx = Dp2Px.convert(this.context, divider.getRightSideLine().getStartPaddingDp());
                endPaddingPx = Dp2Px.convert(this.context, divider.getRightSideLine().getEndPaddingDp());
                this.drawChildRightVertical(child, c, divider.getRightSideLine().getColor(), lineWidthPx, startPaddingPx, endPaddingPx);
            }
            if (!divider.getBottomSideLine().isHave()) continue;
            lineWidthPx = Dp2Px.convert(this.context, divider.getBottomSideLine().getWidthDp());
            startPaddingPx = Dp2Px.convert(this.context, divider.getBottomSideLine().getStartPaddingDp());
            endPaddingPx = Dp2Px.convert(this.context, divider.getBottomSideLine().getEndPaddingDp());
            this.drawChildBottomHorizontal(child, c, divider.getBottomSideLine().getColor(), lineWidthPx, startPaddingPx, endPaddingPx);
        }
    }

    private void drawChildBottomHorizontal(View child, Canvas c, @ColorInt int color, int lineWidthPx, int startPaddingPx, int endPaddingPx) {
        if (!(child.getLayoutParams() instanceof RecyclerView.LayoutParams)) {
            return;
        }
        int leftPadding = startPaddingPx <= 0 ? -lineWidthPx : startPaddingPx;
        int rightPadding = endPaddingPx <= 0 ? lineWidthPx : -endPaddingPx;
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
        int left = child.getLeft() - params.leftMargin + leftPadding;
        int right = child.getRight() + params.rightMargin + rightPadding;
        int top = child.getBottom() + params.bottomMargin;
        int bottom = top + lineWidthPx;
        this.mPaint.setColor(color);
        c.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
    }

    private void drawChildTopHorizontal(View child, Canvas c, @ColorInt int color, int lineWidthPx, int startPaddingPx, int endPaddingPx) {
        if (!(child.getLayoutParams() instanceof RecyclerView.LayoutParams)) {
            return;
        }
        int leftPadding = startPaddingPx <= 0 ? -lineWidthPx : startPaddingPx;
        int rightPadding = endPaddingPx <= 0 ? lineWidthPx : -endPaddingPx;
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
        int left = child.getLeft() - params.leftMargin + leftPadding;
        int right = child.getRight() + params.rightMargin + rightPadding;
        int bottom = child.getTop() - params.topMargin;
        int top = bottom - lineWidthPx;
        this.mPaint.setColor(color);
        c.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
    }

    private void drawChildLeftVertical(View child, Canvas c, @ColorInt int color, int lineWidthPx, int startPaddingPx, int endPaddingPx) {
        if (!(child.getLayoutParams() instanceof RecyclerView.LayoutParams)) {
            return;
        }
        int topPadding = startPaddingPx <= 0 ? -lineWidthPx : startPaddingPx;
        int bottomPadding = endPaddingPx <= 0 ? lineWidthPx : -endPaddingPx;
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
        int top = child.getTop() - params.topMargin + topPadding;
        int bottom = child.getBottom() + params.bottomMargin + bottomPadding;
        int right = child.getLeft() - params.leftMargin;
        int left = right - lineWidthPx;
        this.mPaint.setColor(color);
        c.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
    }

    private void drawChildRightVertical(View child, Canvas c, @ColorInt int color, int lineWidthPx, int startPaddingPx, int endPaddingPx) {
        if (!(child.getLayoutParams() instanceof RecyclerView.LayoutParams)) {
            return;
        }
        int topPadding = startPaddingPx <= 0 ? -lineWidthPx : startPaddingPx;
        int bottomPadding = endPaddingPx <= 0 ? lineWidthPx : -endPaddingPx;
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
        int top = child.getTop() - params.topMargin + topPadding;
        int bottom = child.getBottom() + params.bottomMargin + bottomPadding;
        int left = child.getRight() + params.rightMargin;
        int right = left + lineWidthPx;
        this.mPaint.setColor(color);
        c.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int itemPosition = ((RecyclerView.LayoutParams)view.getLayoutParams()).getViewLayoutPosition();
        Y_Divider divider = this.getDivider(itemPosition);
        if (divider == null) {
            divider = new Y_DividerBuilder().create();
        }
        int left = divider.getLeftSideLine().isHave() ? Dp2Px.convert(this.context, divider.getLeftSideLine().getWidthDp()) : 0;
        int top = divider.getTopSideLine().isHave() ? Dp2Px.convert(this.context, divider.getTopSideLine().getWidthDp()) : 0;
        int right = divider.getRightSideLine().isHave() ? Dp2Px.convert(this.context, divider.getRightSideLine().getWidthDp()) : 0;
        int bottom = divider.getBottomSideLine().isHave() ? Dp2Px.convert(this.context, divider.getBottomSideLine().getWidthDp()) : 0;
        outRect.set(left, top, right, bottom);
    }

    @Nullable
    public abstract Y_Divider getDivider(int var1);
}

