/*
 * Decompiled with CFR 0.152.
 */
package com.kingja.loadsir.core;

import android.content.Context;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.kingja.loadsir.callback.Callback;
import com.kingja.loadsir.callback.SuccessCallback;
import com.kingja.loadsir.core.Convertor;
import com.kingja.loadsir.core.LoadLayout;
import com.kingja.loadsir.core.LoadSir;
import com.kingja.loadsir.core.Transport;
import java.util.List;

public class LoadService<T> {
    private final String TAG = this.getClass().getSimpleName();
    private LoadLayout loadLayout;
    private Convertor<T> convertor;

    LoadService(Convertor<T> convertor, LoadLayout loadLayout, LoadSir.Builder builder) {
        this.convertor = convertor;
        this.loadLayout = loadLayout;
        this.initCallback(builder);
    }

    private void initCallback(LoadSir.Builder builder) {
        List<Callback> callbacks = builder.getCallbacks();
        final Class<? extends Callback> defalutCallback = builder.getDefaultCallback();
        if (callbacks != null && callbacks.size() > 0) {
            for (Callback callback : callbacks) {
                this.loadLayout.setupCallback(callback);
            }
        }
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                if (defalutCallback != null) {
                    LoadService.this.loadLayout.showCallback(defalutCallback);
                }
            }
        });
    }

    public void showSuccess() {
        this.loadLayout.showCallback(SuccessCallback.class);
    }

    public void showCallback(Class<? extends Callback> callback) {
        this.loadLayout.showCallback(callback);
    }

    public void showWithConvertor(T t) {
        if (this.convertor == null) {
            throw new IllegalArgumentException("You haven't set the Convertor.");
        }
        this.loadLayout.showCallback(this.convertor.map(t));
    }

    public LoadLayout getLoadLayout() {
        return this.loadLayout;
    }

    public Class<? extends Callback> getCurrentCallback() {
        return this.loadLayout.getCurrentCallback();
    }

    public LinearLayout getTitleLoadLayout(Context context, ViewGroup rootView, View titleView) {
        LinearLayout newRootView = new LinearLayout(context);
        newRootView.setOrientation(1);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
        newRootView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        rootView.removeView(titleView);
        newRootView.addView(titleView);
        newRootView.addView((View)this.loadLayout, (ViewGroup.LayoutParams)layoutParams);
        return newRootView;
    }

    public LoadService<T> setCallBack(Class<? extends Callback> callback, Transport transport) {
        this.loadLayout.setCallBack(callback, transport);
        return this;
    }
}

