/*
 * Decompiled with CFR 0.152.
 */
package com.kingja.loadsir.callback;

import android.content.Context;
import android.view.View;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class Callback
implements Serializable {
    private View rootView;
    private Context context;
    private OnReloadListener onReloadListener;
    private boolean successViewVisible;

    public Callback() {
    }

    Callback(View view, Context context, OnReloadListener onReloadListener) {
        this.rootView = view;
        this.context = context;
        this.onReloadListener = onReloadListener;
    }

    public Callback setCallback(Context context, OnReloadListener onReloadListener) {
        this.context = context;
        this.onReloadListener = onReloadListener;
        return this;
    }

    public View getRootView() {
        int resId = this.onCreateView();
        if (resId == 0 && this.rootView != null) {
            return this.rootView;
        }
        if (this.onBuildView(this.context) != null) {
            this.rootView = this.onBuildView(this.context);
        }
        if (this.rootView == null) {
            this.rootView = View.inflate((Context)this.context, (int)this.onCreateView(), null);
        }
        this.rootView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (Callback.this.onReloadEvent(Callback.this.context, Callback.this.rootView)) {
                    return;
                }
                if (Callback.this.onReloadListener != null) {
                    Callback.this.onReloadListener.onReload(v);
                }
            }
        });
        this.onViewCreate(this.context, this.rootView);
        return this.rootView;
    }

    protected View onBuildView(Context context) {
        return null;
    }

    public boolean getSuccessVisible() {
        return this.successViewVisible;
    }

    void setSuccessVisible(boolean visible) {
        this.successViewVisible = visible;
    }

    protected boolean onRetry(Context context, View view) {
        return false;
    }

    protected boolean onReloadEvent(Context context, View view) {
        return false;
    }

    public Callback copy() {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        Object obj = null;
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bao);
            oos.writeObject(this);
            oos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bao.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            obj = ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (Callback)obj;
    }

    public View obtainRootView() {
        if (this.rootView == null) {
            this.rootView = View.inflate((Context)this.context, (int)this.onCreateView(), null);
        }
        return this.rootView;
    }

    protected abstract int onCreateView();

    protected void onViewCreate(Context context, View view) {
    }

    public void onAttach(Context context, View view) {
    }

    public void onDetach() {
    }

    public static interface OnReloadListener
    extends Serializable {
        public void onReload(View var1);
    }
}

