/*
 * Decompiled with CFR 0.152.
 */
package br.tiagohm.markdownview.css;

import android.text.TextUtils;
import br.tiagohm.markdownview.css.StyleSheet;
import com.orhanobut.logger.Logger;
import java.util.LinkedHashMap;
import java.util.Map;

public class InternalStyleSheet
implements StyleSheet {
    private static final String NO_MEDIA_QUERY = "NO_MEDIA_QUERY";
    private Map<String, Map<String, Map<String, String>>> mRules = new LinkedHashMap<String, Map<String, Map<String, String>>>();
    private Map<String, String> mFontFaces = new LinkedHashMap<String, String>();
    private String currentMediaQuery = "NO_MEDIA_QUERY";

    public InternalStyleSheet() {
        this.mRules.put(this.currentMediaQuery, new LinkedHashMap());
        this.addRule("p", "text-align: left");
        this.addRule(".text-left", "text-align: left");
        this.addRule(".text-right", "text-align: right");
        this.addRule(".text-center", "text-align: center");
        this.addRule(".text-justify", "text-align: justify");
        this.addRule("red, .red", "color: #f44336");
        this.addRule("pink, .pink", "color: #E91E63");
        this.addRule("purple, .purple", "color: #9C27B0");
        this.addRule("deeppurple, .deeppurple", "color: #673AB7");
        this.addRule("indigo, .indigo", "color: #3F51B5");
        this.addRule("blue, .blue", "color: #2196F3");
        this.addRule("lightblue, .lightblue", "color: #03A9F4");
        this.addRule("cyan, .cyan", "color: #00BCD4");
        this.addRule("teal, .teal", "color: #009688");
        this.addRule("green, .green", "color: #4CAF50");
        this.addRule("lightgreen, .lightgreen", "color: #8BC34A");
        this.addRule("lime, .lime", "color: #CDDC39");
        this.addRule("yellow, .yellow", "color: #FFEB3B");
        this.addRule("amber, .amber", "color: #FFC107");
        this.addRule("orange, .orange", "color: #FF9800");
        this.addRule("deeporange, .deeporange", "color: #FF5722");
        this.addRule("brown, .brown", "color: #795548");
        this.addRule("grey, .grey", "color: #9E9E9E");
        this.addRule("bluegrey, .bluegrey", "color: #607D8B");
        this.addRule("smaller, .text-smaller", "font-size: smaller");
        this.addRule("small, .text-small", "font-size: small");
        this.addRule("medium, .text-medium", "font-size: medium");
        this.addRule("large, .text-large", "font-size: large");
        this.addRule("larger, .text-larger", "font-size: larger");
        this.addRule("x-small, .text-x-small", "font-size: x-small");
        this.addRule("x-large, .text-x-large", "font-size: x-large");
        this.addRule("xx-small, .text-xx-small", "font-size: xx-small");
        this.addRule("xx-large, .text-xx-large", "font-size: xx-large");
        this.addRule("body", "margin-bottom: 50px !important");
        this.addRule(".scrollup", "width: 55px", "height: 55px", "position: fixed", "bottom: 15px", "right: 15px", "visibility: hidden", "display: flex", "align-items: center", "justify-content: center", "margin: 0 !important", "line-height: 70px", "box-shadow: 0 0 4px rgba(0, 0, 0, 0.14), 0 4px 8px rgba(0, 0, 0, 0.28)", "border-radius: 50%", "color: #fff", "padding: 5px");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.mFontFaces.entrySet()) {
            sb.append("@font-face {");
            sb.append(entry.getValue());
            sb.append("}\n");
        }
        for (Map.Entry<String, Object> entry : this.mRules.entrySet()) {
            if (!entry.getKey().equals(NO_MEDIA_QUERY)) {
                sb.append("@media ");
                sb.append(entry.getKey());
                sb.append(" {\n");
            }
            for (Map.Entry e : ((Map)entry.getValue()).entrySet()) {
                sb.append((String)e.getKey());
                sb.append(" {");
                for (Map.Entry declaration : ((Map)e.getValue()).entrySet()) {
                    sb.append((String)declaration.getKey());
                    sb.append(":");
                    sb.append((String)declaration.getValue());
                    sb.append(";");
                }
                sb.append("}\n");
            }
            if (entry.getKey().equals(NO_MEDIA_QUERY)) continue;
            sb.append("}\n");
        }
        return sb.toString();
    }

    @Override
    public String toHTML() {
        return "<style>\n" + this.toString() + "\n</style>\n";
    }

    private Map<String, Map<String, String>> getCurrentMediaQuery() {
        return this.mRules.get(this.currentMediaQuery);
    }

    public void addMedia(String mediaQuery) {
        if (mediaQuery != null && mediaQuery.trim().length() > 0 && !this.mRules.containsKey(mediaQuery = mediaQuery.trim())) {
            this.mRules.put(mediaQuery, new LinkedHashMap());
            this.currentMediaQuery = mediaQuery;
        }
    }

    public void addFontFace(String fontFamily, String fontStretch, String fontStyle, String fontWeight, String ... src) {
        if (!TextUtils.isEmpty((CharSequence)fontFamily) && src.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("font-family:").append(fontFamily).append(";");
            sb.append("font-stretch:").append(TextUtils.isEmpty((CharSequence)fontStretch) ? "normal" : fontStretch).append(";");
            sb.append("font-style:").append(TextUtils.isEmpty((CharSequence)fontStyle) ? "normal" : fontStyle).append(";");
            sb.append("font-weight:").append(TextUtils.isEmpty((CharSequence)fontWeight) ? "normal" : fontWeight).append(";");
            sb.append("src:");
            for (int i = 0; i < src.length; ++i) {
                sb.append(src[i]);
                if (i >= src.length - 1) continue;
                sb.append(",");
            }
            sb.append(";");
            this.mFontFaces.put(fontFamily.trim(), sb.toString());
        }
    }

    public void endMedia() {
        this.currentMediaQuery = NO_MEDIA_QUERY;
    }

    public void addRule(String selector, String ... declarations) {
        if (selector != null && selector.trim().length() > 0 && declarations.length > 0) {
            selector = selector.trim();
            if (!this.getCurrentMediaQuery().containsKey(selector)) {
                this.getCurrentMediaQuery().put(selector, new LinkedHashMap());
            }
            for (String declaration : declarations) {
                if (declaration == null || declaration.trim().length() <= 0) continue;
                String[] nameAndValue = declaration.trim().split(":");
                if (nameAndValue.length == 2) {
                    String name = nameAndValue[0].trim();
                    String value = nameAndValue[1].trim();
                    this.getCurrentMediaQuery().get(selector).put(name, value);
                    continue;
                }
                Logger.e((String)("invalid css: '" + declaration + "' in selector: " + selector), (Object[])new Object[0]);
            }
        }
    }

    public void removeRule(String selector) {
        this.getCurrentMediaQuery().remove(selector);
    }

    public void removeDeclaration(String selector, String declarationName) {
        if (!TextUtils.isEmpty((CharSequence)selector) && this.getCurrentMediaQuery().containsKey(selector)) {
            this.getCurrentMediaQuery().get(selector).remove(declarationName);
        }
    }

    public void replaceDeclaration(String selector, String declarationName, String newDeclarationValue) {
        if (!TextUtils.isEmpty((CharSequence)selector) && !TextUtils.isEmpty((CharSequence)declarationName) && this.getCurrentMediaQuery().containsKey(selector) && this.getCurrentMediaQuery().get(selector).containsKey(declarationName)) {
            this.getCurrentMediaQuery().get(selector).put(declarationName, newDeclarationValue);
        }
    }
}

