/*
 * Decompiled with CFR 0.152.
 */
package br.tiagohm.markdownview.ext.bean.internal;

import br.tiagohm.markdownview.MarkdownView;
import br.tiagohm.markdownview.ext.bean.Bean;
import br.tiagohm.markdownview.ext.bean.BeanExtension;
import com.orhanobut.logger.Logger;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.options.DataHolder;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class BeanNodeRenderer
implements NodeRenderer {
    private final MarkdownView mMarkdownView;

    public BeanNodeRenderer(DataHolder options) {
        this.mMarkdownView = (MarkdownView)((Object)options.get(BeanExtension.BEAN_VIEW));
    }

    private static Object getBeanAttributeValue(String name, Object bean) {
        Class<?> beanClass = bean.getClass();
        String[] fieldNames = name.split("\\.");
        if (fieldNames != null && fieldNames.length >= 1) {
            Method fieldMethod;
            String methodName = fieldNames[0];
            String methodNameCamelCase = Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
            try {
                fieldMethod = beanClass.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    fieldMethod = beanClass.getMethod("get" + methodNameCamelCase, new Class[0]);
                }
                catch (NoSuchMethodException e1) {
                    try {
                        fieldMethod = beanClass.getMethod("is" + methodNameCamelCase, new Class[0]);
                    }
                    catch (NoSuchMethodException e2) {
                        Logger.d((String)"NoSuchMethodException: ", (Object[])new Object[]{methodName});
                        return null;
                    }
                }
            }
            if (fieldMethod != null) {
                Object o;
                try {
                    fieldMethod.setAccessible(true);
                    o = fieldMethod.invoke(bean, new Object[0]);
                }
                catch (Exception e) {
                    return null;
                }
                if (o == null) {
                    return null;
                }
                if (fieldNames.length == 1) {
                    return o;
                }
                return BeanNodeRenderer.getBeanAttributeValue(name.substring(name.indexOf(".") + 1), o);
            }
        }
        return null;
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(Bean.class, (CustomNodeRenderer)new CustomNodeRenderer<Bean>(){

            public void render(Bean node, NodeRendererContext context, HtmlWriter html) {
                BeanNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(Bean node, NodeRendererContext context, HtmlWriter html) {
        if (this.mMarkdownView != null && this.mMarkdownView.getBean() != null) {
            String name = node.getText().toString().trim();
            Object value = BeanNodeRenderer.getBeanAttributeValue(name, this.mMarkdownView.getBean());
            if (value != null) {
                html.attr((CharSequence)"class", (CharSequence)"bean");
                html.withAttr().tag((CharSequence)"span");
                html.append((CharSequence)value.toString());
                html.tag((CharSequence)"/span");
            }
        } else {
            context.renderChildren((Node)node);
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new BeanNodeRenderer(options);
        }
    }
}

