/*
 * Decompiled with CFR 0.152.
 */
package br.tiagohm.markdownview.ext.localization.internal;

import android.content.Context;
import br.tiagohm.markdownview.ext.localization.Localization;
import br.tiagohm.markdownview.ext.localization.LocalizationExtension;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class LocalizationNodeRenderer
implements NodeRenderer {
    private final Context mContext;

    public LocalizationNodeRenderer(DataHolder options) {
        this.mContext = (Context)options.get(LocalizationExtension.LOCALIZATION_CONTEXT);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(Localization.class, (CustomNodeRenderer)new CustomNodeRenderer<Localization>(){

            public void render(Localization node, NodeRendererContext context, HtmlWriter html) {
                LocalizationNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(Localization node, NodeRendererContext context, HtmlWriter html) {
        if (this.mContext != null) {
            String packageName = this.mContext.getPackageName();
            String name = node.getText().toString().trim();
            int identifier = this.mContext.getResources().getIdentifier(name, "string", packageName);
            if (identifier > 0) {
                html.attr((CharSequence)"class", (CharSequence)"localization");
                html.withAttr().tag((CharSequence)"span");
                html.append((CharSequence)this.mContext.getString(identifier));
                html.tag((CharSequence)"/span");
            }
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new LocalizationNodeRenderer(options);
        }
    }
}

