/*
 * Decompiled with CFR 0.152.
 */
package br.tiagohm.markdownview.css;

import android.text.TextUtils;
import br.tiagohm.markdownview.css.StyleSheet;
import com.orhanobut.logger.Logger;
import java.util.LinkedHashMap;
import java.util.Map;

public class InternalStyleSheet
implements StyleSheet {
    private static final String NO_MEDIA_QUERY = "NO_MEDIA_QUERY";
    private Map<String, Map<String, Map<String, String>>> mRules = new LinkedHashMap<String, Map<String, Map<String, String>>>();
    private Map<String, String> mFontFaces = new LinkedHashMap<String, String>();
    private String currentMediaQuery = "NO_MEDIA_QUERY";

    public InternalStyleSheet() {
        this.mRules.put(this.currentMediaQuery, new LinkedHashMap());
    }

    private Map<String, Map<String, String>> getCurrentMediaQuery() {
        return this.mRules.get(this.currentMediaQuery);
    }

    public void addMedia(String mediaQuery) {
        if (mediaQuery != null && mediaQuery.trim().length() > 0 && !this.mRules.containsKey(mediaQuery = mediaQuery.trim())) {
            this.mRules.put(mediaQuery, new LinkedHashMap());
            this.currentMediaQuery = mediaQuery;
        }
    }

    public void addFontFace(String fontFamily, String fontStretch, String fontStyle, String fontWeight, String ... src) {
        if (!TextUtils.isEmpty((CharSequence)fontFamily) && src.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("font-family:").append(fontFamily).append(";");
            sb.append("font-stretch:").append(TextUtils.isEmpty((CharSequence)fontStretch) ? "normal" : fontStretch).append(";");
            sb.append("font-style:").append(TextUtils.isEmpty((CharSequence)fontStyle) ? "normal" : fontStyle).append(";");
            sb.append("font-weight:").append(TextUtils.isEmpty((CharSequence)fontWeight) ? "normal" : fontWeight).append(";");
            sb.append("src:");
            for (int i = 0; i < src.length; ++i) {
                sb.append(src[i]);
                if (i >= src.length - 1) continue;
                sb.append(",");
            }
            sb.append(";");
            this.mFontFaces.put(fontFamily.trim(), sb.toString());
        }
    }

    public void endMedia() {
        this.currentMediaQuery = NO_MEDIA_QUERY;
    }

    public void addRule(String selector, String ... declarations) {
        if (selector != null && selector.trim().length() > 0 && declarations.length > 0) {
            selector = selector.trim();
            if (!this.getCurrentMediaQuery().containsKey(selector)) {
                this.getCurrentMediaQuery().put(selector, new LinkedHashMap());
            }
            for (String declaration : declarations) {
                if (declaration == null || declaration.trim().length() <= 0) continue;
                String[] nameAndValue = declaration.trim().split(":");
                if (nameAndValue.length == 2) {
                    String name = nameAndValue[0].trim();
                    String value = nameAndValue[1].trim();
                    this.getCurrentMediaQuery().get(selector).put(name, value);
                    continue;
                }
                Logger.e((String)("invalid css: '" + declaration + "' in selector: " + selector), (Object[])new Object[0]);
            }
        }
    }

    public void removeRule(String selector) {
        this.getCurrentMediaQuery().remove(selector);
    }

    public void removeDeclaration(String selector, String declarationName) {
        if (!TextUtils.isEmpty((CharSequence)selector) && this.getCurrentMediaQuery().containsKey(selector)) {
            this.getCurrentMediaQuery().get(selector).remove(declarationName);
        }
    }

    public void replaceDeclaration(String selector, String declarationName, String newDeclarationValue) {
        if (!TextUtils.isEmpty((CharSequence)selector) && !TextUtils.isEmpty((CharSequence)declarationName) && this.getCurrentMediaQuery().containsKey(selector) && this.getCurrentMediaQuery().get(selector).containsKey(declarationName)) {
            this.getCurrentMediaQuery().get(selector).put(declarationName, newDeclarationValue);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.mFontFaces.entrySet()) {
            sb.append("@font-face {");
            sb.append(entry.getValue());
            sb.append("}\n");
        }
        for (Map.Entry<String, Object> entry : this.mRules.entrySet()) {
            if (!entry.getKey().equals(NO_MEDIA_QUERY)) {
                sb.append("@media ");
                sb.append(entry.getKey());
                sb.append(" {\n");
            }
            for (Map.Entry e : ((Map)entry.getValue()).entrySet()) {
                sb.append((String)e.getKey());
                sb.append(" {");
                for (Map.Entry declaration : ((Map)e.getValue()).entrySet()) {
                    sb.append((String)declaration.getKey());
                    sb.append(":");
                    sb.append((String)declaration.getValue());
                    sb.append(";");
                }
                sb.append("}\n");
            }
            if (entry.getKey().equals(NO_MEDIA_QUERY)) continue;
            sb.append("}\n");
        }
        return sb.toString();
    }

    @Override
    public String toHTML() {
        return "<style>\n" + this.toString() + "\n</style>\n";
    }
}

