/*
 * Decompiled with CFR 0.152.
 */
package br.tiagohm.markdownview;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.FrameLayout;
import br.tiagohm.markdownview.R;
import br.tiagohm.markdownview.Utils;
import br.tiagohm.markdownview.css.ExternalStyleSheet;
import br.tiagohm.markdownview.css.StyleSheet;
import br.tiagohm.markdownview.ext.button.ButtonExtension;
import br.tiagohm.markdownview.ext.emoji.EmojiExtension;
import br.tiagohm.markdownview.ext.kbd.Keystroke;
import br.tiagohm.markdownview.ext.kbd.KeystrokeExtension;
import br.tiagohm.markdownview.ext.label.LabelExtension;
import br.tiagohm.markdownview.ext.mark.Mark;
import br.tiagohm.markdownview.ext.mark.MarkExtension;
import br.tiagohm.markdownview.ext.mathjax.MathJax;
import br.tiagohm.markdownview.ext.mathjax.MathJaxExtension;
import br.tiagohm.markdownview.ext.twitter.TwitterExtension;
import br.tiagohm.markdownview.ext.video.VideoLinkExtension;
import br.tiagohm.markdownview.js.ExternalScript;
import br.tiagohm.markdownview.js.JavaScript;
import com.orhanobut.logger.Logger;
import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.util.TextCollectingVisitor;
import com.vladsch.flexmark.ext.abbreviation.Abbreviation;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughSubscriptExtension;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.AttributeProvider;
import com.vladsch.flexmark.html.AttributeProviderFactory;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.IndependentAttributeProviderFactory;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.superscript.SuperscriptExtension;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class MarkdownView
extends FrameLayout {
    public static final JavaScript JQUERY_3 = new ExternalScript("file:///android_asset/js/jquery-3.1.1.min.js", false, false);
    public static final JavaScript HIGHLIGHTJS = new ExternalScript("file:///android_asset/js/highlight.js", false, true);
    public static final JavaScript MATHJAX = new ExternalScript("https://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS_CHTML", false, true);
    public static final JavaScript HIGHLIGHT_INIT = new ExternalScript("file:///android_asset/js/highlight-init.js", false, true);
    public static final JavaScript MATHJAX_CONFIG = new ExternalScript("file:///android_asset/js/mathjax-config.js", false, true);
    public static final JavaScript TOOLTIPSTER_JS = new ExternalScript("file:///android_asset/js/tooltipster.bundle.min.js", false, true);
    public static final JavaScript TOOLTIPSTER_INIT = new ExternalScript("file:///android_asset/js/tooltipster-init.js", false, true);
    public static final StyleSheet TOOLTIPSTER_CSS = new ExternalStyleSheet("file:///android_asset/css/tooltipster.bundle.min.css");
    private static final List<Extension> EXTENSIONS = Arrays.asList(TablesExtension.create(), TaskListExtension.create(), AbbreviationExtension.create(), AutolinkExtension.create(), MarkExtension.create(), StrikethroughSubscriptExtension.create(), SuperscriptExtension.create(), KeystrokeExtension.create(), MathJaxExtension.create(), FootnoteExtension.create(), EmojiExtension.create(), VideoLinkExtension.create(), TwitterExtension.create(), LabelExtension.create(), ButtonExtension.create());
    private final DataHolder OPTIONS = new MutableDataSet().set(FootnoteExtension.FOOTNOTE_REF_PREFIX, (Object)"[").set(FootnoteExtension.FOOTNOTE_REF_SUFFIX, (Object)"]").set(HtmlRenderer.FENCED_CODE_LANGUAGE_CLASS_PREFIX, (Object)"").set(HtmlRenderer.FENCED_CODE_NO_LANGUAGE_CLASS, (Object)"nohighlight");
    private final List<StyleSheet> mStyleSheets = new LinkedList<StyleSheet>();
    private final HashSet<JavaScript> mScripts = new LinkedHashSet<JavaScript>();
    private WebView mWebView;
    private boolean mEscapeHtml = true;
    private OnElementListener mOnElementListener;

    public MarkdownView(Context context) {
        this(context, null);
    }

    public MarkdownView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MarkdownView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mWebView = new WebView(context, null, 0);
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        try {
            this.mWebView.setWebChromeClient(new WebChromeClient());
            this.mWebView.getSettings().setJavaScriptEnabled(true);
            this.mWebView.getSettings().setLoadsImagesAutomatically(true);
            this.mWebView.addJavascriptInterface((Object)new EventDispatcher(), "android");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            TypedArray attr = this.getContext().obtainStyledAttributes(attrs, R.styleable.MarkdownView);
            this.mEscapeHtml = attr.getBoolean(R.styleable.MarkdownView_escapeHtml, true);
            attr.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addView((View)this.mWebView);
        this.addJavascript(JQUERY_3);
    }

    public void setOnElementListener(OnElementListener listener) {
        this.mOnElementListener = listener;
    }

    public MarkdownView setEscapeHtml(boolean flag) {
        this.mEscapeHtml = flag;
        return this;
    }

    public MarkdownView setEmojiRootPath(String path) {
        ((MutableDataHolder)this.OPTIONS).set(EmojiExtension.ROOT_IMAGE_PATH, (Object)path);
        return this;
    }

    public MarkdownView setEmojiImageExtension(String ext) {
        ((MutableDataHolder)this.OPTIONS).set(EmojiExtension.IMAGE_EXT, (Object)ext);
        return this;
    }

    public MarkdownView addStyleSheet(StyleSheet s) {
        if (s != null && !this.mStyleSheets.contains(s)) {
            this.mStyleSheets.add(s);
        }
        return this;
    }

    public MarkdownView replaceStyleSheet(StyleSheet oldStyle, StyleSheet newStyle) {
        if (oldStyle != newStyle) {
            if (newStyle == null) {
                this.mStyleSheets.remove(oldStyle);
            } else {
                int index = this.mStyleSheets.indexOf(oldStyle);
                if (index >= 0) {
                    this.mStyleSheets.set(index, newStyle);
                } else {
                    this.addStyleSheet(newStyle);
                }
            }
        }
        return this;
    }

    public MarkdownView removeStyleSheet(StyleSheet s) {
        this.mStyleSheets.remove(s);
        return this;
    }

    public MarkdownView addJavascript(JavaScript js) {
        this.mScripts.add(js);
        return this;
    }

    public MarkdownView removeJavaScript(JavaScript js) {
        this.mScripts.remove(js);
        return this;
    }

    private String parseBuildAndRender(String text) {
        Parser parser = Parser.builder((DataHolder)this.OPTIONS).extensions(EXTENSIONS).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)this.OPTIONS).escapeHtml(this.mEscapeHtml).attributeProviderFactory((AttributeProviderFactory)new IndependentAttributeProviderFactory(){

            public AttributeProvider create(NodeRendererContext context) {
                return new CustomAttributeProvider();
            }
        }).nodeRendererFactory((NodeRendererFactory)new NodeRendererFactoryImpl()).extensions(EXTENSIONS).build();
        return renderer.render(parser.parse(text));
    }

    public void loadMarkdown(String text) {
        String html = this.parseBuildAndRender(text);
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\n");
        sb.append("<head>\n");
        for (StyleSheet s : this.mStyleSheets) {
            sb.append(s.toHTML());
        }
        for (JavaScript js : this.mScripts) {
            sb.append(js.toHTML());
        }
        sb.append("</head>\n");
        sb.append("<body>\n");
        sb.append("<div class=\"container\">\n");
        sb.append(html);
        sb.append("</div>\n");
        sb.append("</body>\n");
        sb.append("</html>");
        html = sb.toString();
        Logger.d((Object)html);
        this.mWebView.loadDataWithBaseURL("", html, "text/html", "UTF-8", "");
    }

    public void loadMarkdownFromAsset(String path) {
        this.loadMarkdown(Utils.getStringFromAssetFile(this.getContext().getAssets(), path));
    }

    public void loadMarkdownFromFile(File file) {
        this.loadMarkdown(Utils.getStringFromFile(file));
    }

    public void loadMarkdownFromUrl(String url) {
        new LoadMarkdownUrlTask().execute(new String[]{url});
    }

    protected class EventDispatcher {
        protected EventDispatcher() {
        }

        @JavascriptInterface
        public void onButtonTap(String id) {
            if (MarkdownView.this.mOnElementListener != null) {
                MarkdownView.this.mOnElementListener.onButtonTap(id);
            }
        }

        @JavascriptInterface
        public void onCodeTap(String lang, String code) {
            if (MarkdownView.this.mOnElementListener != null) {
                MarkdownView.this.mOnElementListener.onCodeTap(lang, code);
            }
        }

        @JavascriptInterface
        public void onHeadingTap(int level, String text) {
            if (MarkdownView.this.mOnElementListener != null) {
                MarkdownView.this.mOnElementListener.onHeadingTap(level, text);
            }
        }

        @JavascriptInterface
        public void onImageTap(String src, int width, int height) {
            if (MarkdownView.this.mOnElementListener != null) {
                MarkdownView.this.mOnElementListener.onImageTap(src, width, height);
            }
        }

        @JavascriptInterface
        public void onMarkTap(String text) {
            if (MarkdownView.this.mOnElementListener != null) {
                MarkdownView.this.mOnElementListener.onMarkTap(text);
            }
        }

        @JavascriptInterface
        public void onKeystrokeTap(String key) {
            if (MarkdownView.this.mOnElementListener != null) {
                MarkdownView.this.mOnElementListener.onKeystrokeTap(key);
            }
        }

        @JavascriptInterface
        public void onLinkTap(String href, String text) {
            if (MarkdownView.this.mOnElementListener != null) {
                MarkdownView.this.mOnElementListener.onLinkTap(href, text);
            }
        }
    }

    private class LoadMarkdownUrlTask
    extends AsyncTask<String, Void, String> {
        private LoadMarkdownUrlTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String doInBackground(String ... params) {
            String url = params[0];
            InputStream is = null;
            try {
                URLConnection connection = new URL(url).openConnection();
                connection.setReadTimeout(5000);
                connection.setConnectTimeout(5000);
                connection.setRequestProperty("Accept-Charset", "UTF-8");
                is = connection.getInputStream();
                String string = Utils.getStringFromInputStream(is);
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                String string = "";
                return string;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        protected void onPostExecute(String s) {
            MarkdownView.this.loadMarkdown(s);
        }
    }

    public class CustomAttributeProvider
    implements AttributeProvider {
        public void setAttributes(Node node, AttributablePart part, Attributes attributes) {
            if (node instanceof FencedCodeBlock) {
                String language;
                if (part.getName().equals("NODE") && !TextUtils.isEmpty((CharSequence)(language = ((FencedCodeBlock)node).getInfo().toString())) && !language.equals("nohighlight")) {
                    MarkdownView.this.addJavascript(HIGHLIGHTJS);
                    MarkdownView.this.addJavascript(HIGHLIGHT_INIT);
                    attributes.addValue((CharSequence)"language", (CharSequence)language);
                    attributes.addValue((CharSequence)"onclick", (CharSequence)String.format("javascript:android.onCodeTap('%s', this.textContent);", language));
                }
            } else if (node instanceof MathJax) {
                MarkdownView.this.addJavascript(MATHJAX);
                MarkdownView.this.addJavascript(MATHJAX_CONFIG);
            } else if (node instanceof Abbreviation) {
                MarkdownView.this.addJavascript(TOOLTIPSTER_JS);
                MarkdownView.this.addStyleSheet(TOOLTIPSTER_CSS);
                MarkdownView.this.addJavascript(TOOLTIPSTER_INIT);
                attributes.addValue((CharSequence)"class", (CharSequence)"tooltip");
            } else if (node instanceof Heading) {
                attributes.addValue((CharSequence)"onclick", (CharSequence)String.format("javascript:android.onHeadingTap(%d, '%s');", ((Heading)node).getLevel(), ((Heading)node).getText()));
            } else if (node instanceof Image) {
                attributes.addValue((CharSequence)"onclick", (CharSequence)String.format("javascript: android.onImageTap(this.src, this.clientWidth, this.clientHeight);", new Object[0]));
            } else if (node instanceof Mark) {
                attributes.addValue((CharSequence)"onclick", (CharSequence)String.format("javascript: android.onMarkTap(this.textContent)", new Object[0]));
            } else if (node instanceof Keystroke) {
                attributes.addValue((CharSequence)"onclick", (CharSequence)String.format("javascript: android.onKeystrokeTap(this.textContent)", new Object[0]));
            } else if (node instanceof Link || node instanceof AutoLink) {
                attributes.addValue((CharSequence)"onclick", (CharSequence)String.format("javascript: android.onLinkTap(this.href, this.textContent)", new Object[0]));
            }
        }
    }

    public static class NodeRendererFactoryImpl
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new NodeRenderer(){

                public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
                    HashSet set = new HashSet();
                    set.add(new NodeRenderingHandler(Image.class, (CustomNodeRenderer)new CustomNodeRenderer<Image>(){

                        public void render(Image node, NodeRendererContext context, HtmlWriter html) {
                            if (!context.isDoNotRenderLinks()) {
                                int index;
                                String altText = new TextCollectingVisitor().collectAndGetText((Node)node);
                                ResolvedLink resolvedLink = context.resolveLink(LinkType.IMAGE, (CharSequence)node.getUrl().unescape(), null);
                                String url = resolvedLink.getUrl();
                                if (!node.getUrlContent().isEmpty()) {
                                    String content = Escaping.percentEncodeUrl((CharSequence)node.getUrlContent()).replace("+", "%2B").replace("%3D", "=").replace("%26", "&amp;");
                                    url = url + content;
                                }
                                if ((index = url.indexOf(64)) >= 0) {
                                    String[] dimensions = url.substring(index + 1, url.length()).split("\\|");
                                    url = url.substring(0, index);
                                    if (dimensions.length == 2) {
                                        String width = TextUtils.isEmpty((CharSequence)dimensions[0]) ? "auto" : dimensions[0];
                                        String height = TextUtils.isEmpty((CharSequence)dimensions[1]) ? "auto" : dimensions[1];
                                        html.attr((CharSequence)"style", (CharSequence)("width: " + width + "; height: " + height));
                                    }
                                }
                                html.attr((CharSequence)"src", (CharSequence)url);
                                html.attr((CharSequence)"alt", (CharSequence)altText);
                                if (node.getTitle().isNotNull()) {
                                    html.attr((CharSequence)"title", (CharSequence)node.getTitle().unescape());
                                }
                                html.srcPos(node.getChars()).withAttr(resolvedLink).tagVoid((CharSequence)"img");
                            }
                        }
                    }));
                    return set;
                }
            };
        }
    }

    public static interface OnElementListener {
        public void onButtonTap(String var1);

        public void onCodeTap(String var1, String var2);

        public void onHeadingTap(int var1, String var2);

        public void onImageTap(String var1, int var2, int var3);

        public void onLinkTap(String var1, String var2);

        public void onKeystrokeTap(String var1);

        public void onMarkTap(String var1);
    }
}

