/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasdarimont.keycloak.embedded.support;

import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.keycloak.common.ClientConnection;
import org.keycloak.services.filters.AbstractRequestFilter;

public class KeycloakUndertowRequestFilter
extends AbstractRequestFilter
implements Filter {
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws UnsupportedEncodingException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        request.setCharacterEncoding("UTF-8");
        this.filter(this.createClientConnection(request), session -> {
            try {
                filterChain.doFilter(servletRequest, servletResponse);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected ClientConnection createClientConnection(HttpServletRequest request) {
        return new UndertowClientConnection(request);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public static class UndertowClientConnection
    implements ClientConnection {
        private final HttpServletRequest request;

        public UndertowClientConnection(HttpServletRequest request) {
            this.request = request;
        }

        public String getRemoteAddr() {
            String forwardedFor = this.request.getHeader("X-Forwarded-For");
            if (forwardedFor != null) {
                return forwardedFor;
            }
            return this.request.getRemoteAddr();
        }

        public String getRemoteHost() {
            return this.request.getRemoteHost();
        }

        public int getRemotePort() {
            return this.request.getRemotePort();
        }

        public String getLocalAddr() {
            return this.request.getLocalAddr();
        }

        public int getLocalPort() {
            return this.request.getLocalPort();
        }
    }
}

