/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasdarimont.keycloak.embedded.support;

import com.github.thomasdarimont.keycloak.embedded.support.KeycloakInitialContext;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import javax.sql.DataSource;
import org.infinispan.manager.DefaultCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class DynamicJndiContextFactoryBuilder
implements InitialContextFactoryBuilder {
    private static final Logger log = LoggerFactory.getLogger(DynamicJndiContextFactoryBuilder.class);
    public static final String JNDI_SPRING_DATASOURCE = "spring/datasource";
    public static final String JNDI_CACHE_MANAGAER = "spring/infinispan/cacheManager";
    public static final String JNDI_EXECUTOR_SERVICE = "java:jboss/ee/concurrency/executor/storage-provider-threads";
    private final InitialContext fixedInitialContext;

    public DynamicJndiContextFactoryBuilder(DataSource dataSource, DefaultCacheManager cacheManager, ExecutorService executorService) {
        this.fixedInitialContext = this.createFixedInitialContext(dataSource, cacheManager, executorService);
    }

    protected InitialContext createFixedInitialContext(DataSource dataSource, DefaultCacheManager cacheManager, ExecutorService executorService) {
        Hashtable<String, Object> jndiEnv = new Hashtable<String, Object>();
        jndiEnv.put(JNDI_SPRING_DATASOURCE, dataSource);
        jndiEnv.put(JNDI_CACHE_MANAGAER, cacheManager);
        jndiEnv.put(JNDI_EXECUTOR_SERVICE, executorService);
        try {
            return new KeycloakInitialContext(jndiEnv);
        }
        catch (NamingException ne) {
            throw new RuntimeException("Could not create KeycloakInitialContext", ne);
        }
    }

    @PostConstruct
    public void init() {
        try {
            NamingManager.setInitialContextFactoryBuilder(this);
        }
        catch (NamingException e) {
            log.error("Could not configure InitialContextFactoryBuilder", (Throwable)e);
        }
    }

    @Override
    public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> environment) {
        if (environment == null || environment.isEmpty()) {
            return env -> this.fixedInitialContext;
        }
        String factoryClassName = (String)environment.get("java.naming.factory.initial");
        if (factoryClassName != null) {
            try {
                Class<?> factoryClass = Thread.currentThread().getContextClassLoader().loadClass(factoryClassName);
                return (InitialContextFactory)BeanUtils.instantiateClass(factoryClass, InitialContextFactory.class);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

