/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasdarimont.keycloak.embedded;

import com.github.thomasdarimont.keycloak.embedded.KeycloakCustomProperties;
import com.github.thomasdarimont.keycloak.embedded.support.SpringBootConfigProvider;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import org.keycloak.Config;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.ExportImportManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.resources.KeycloakApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class EmbeddedKeycloakApplication
extends KeycloakApplication {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedKeycloakApplication.class);
    private final KeycloakCustomProperties customProperties;

    public EmbeddedKeycloakApplication(@Context ServletContext context) {
        this.customProperties = (KeycloakCustomProperties)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context).getBean(KeycloakCustomProperties.class);
    }

    protected ExportImportManager bootstrap() {
        ExportImportManager exportImportManager = super.bootstrap();
        this.tryCreateMasterRealmAdminUser();
        this.tryImportRealm();
        return exportImportManager;
    }

    protected void loadConfig() {
        Config.init((Config.ConfigProvider)SpringBootConfigProvider.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryCreateMasterRealmAdminUser() {
        if (!this.customProperties.getAdminUser().isCreateAdminUserEnabled()) {
            log.warn("Skipping creation of keycloak master adminUser.");
            return;
        }
        KeycloakCustomProperties.AdminUser adminUser = this.customProperties.getAdminUser();
        String username = adminUser.getUsername();
        if (!StringUtils.hasLength((String)username) && !StringUtils.hasText((String)username)) {
            return;
        }
        KeycloakSession session = EmbeddedKeycloakApplication.getSessionFactory().create();
        KeycloakTransactionManager transaction = session.getTransactionManager();
        try {
            transaction.begin();
            boolean randomPassword = false;
            String password = adminUser.getPassword();
            if (StringUtils.isEmpty((Object)adminUser.getPassword())) {
                password = UUID.randomUUID().toString();
                randomPassword = true;
            }
            new ApplianceBootstrap(session).createMasterRealmUser(username, password);
            if (randomPassword) {
                log.info("Generated admin password: {}", (Object)password);
            }
            ServicesLogger.LOGGER.addUserSuccess(username, Config.getAdminRealm());
            transaction.commit();
        }
        catch (IllegalStateException e) {
            transaction.rollback();
            ServicesLogger.LOGGER.addUserFailedUserExists(username, Config.getAdminRealm());
        }
        catch (Throwable t) {
            transaction.rollback();
            ServicesLogger.LOGGER.addUserFailed(t, username, Config.getAdminRealm());
        }
        finally {
            session.close();
        }
    }

    protected void tryImportRealm() {
        File file;
        KeycloakCustomProperties.Migration imex = this.customProperties.getMigration();
        Resource importLocation = imex.getImportLocation();
        if (!importLocation.exists()) {
            log.info("Could not find keycloak import file {}", (Object)importLocation);
            return;
        }
        try {
            file = importLocation.getFile();
        }
        catch (IOException e) {
            log.error("Could not read keycloak import file {}", (Object)importLocation, (Object)e);
            return;
        }
        log.info("Starting Keycloak realm configuration import from location: {}", (Object)importLocation);
        KeycloakSession session = EmbeddedKeycloakApplication.getSessionFactory().create();
        ExportImportConfig.setAction((String)"import");
        ExportImportConfig.setProvider((String)imex.getImportProvider());
        ExportImportConfig.setFile((String)file.getAbsolutePath());
        ExportImportManager manager = new ExportImportManager(session);
        manager.runImport();
        session.close();
        log.info("Keycloak realm configuration import finished.");
    }
}

