/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasdarimont.keycloak.embedded.scripting;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.AuthenticatorSpi;
import org.keycloak.authentication.authenticators.browser.DeployedScriptAuthenticatorFactory;
import org.keycloak.authorization.policy.provider.PolicySpi;
import org.keycloak.authorization.policy.provider.js.DeployedScriptPolicyFactory;
import org.keycloak.common.Profile;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.protocol.ProtocolMapperSpi;
import org.keycloak.protocol.oidc.mappers.DeployedScriptOIDCProtocolMapper;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.KeycloakDeploymentInfo;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderManager;
import org.keycloak.provider.ProviderManagerDeployer;
import org.keycloak.provider.ProviderManagerRegistry;
import org.keycloak.representations.provider.ScriptProviderDescriptor;
import org.keycloak.representations.provider.ScriptProviderMetadata;
import org.keycloak.util.JsonSerialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

@AutoService(value={AuthenticatorFactory.class})
public class EmbeddedScriptBasedComponentRegistrar
implements AuthenticatorFactory,
EnvironmentDependentProviderFactory {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedScriptBasedComponentRegistrar.class);
    public static final String KEYCLOAK_SCRIPTS_JSON_LOCATION = "META-INF/keycloak-scripts.json";

    public String getId() {
        return "script-component-registrar";
    }

    public Authenticator create(KeycloakSession session) {
        return null;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        KeycloakScripts keycloakScripts = this.discoverScriptComponents();
        if (keycloakScripts == null) {
            return;
        }
        this.deployKeycloakScriptComponents((ProviderManagerDeployer)factory, keycloakScripts);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeycloakScripts discoverScriptComponents() {
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(KEYCLOAK_SCRIPTS_JSON_LOCATION);){
            if (in == null) {
                log.info("Could detect any script-based components.");
                KeycloakScripts keycloakScripts2 = null;
                return keycloakScripts2;
            }
            KeycloakScripts keycloakScripts3 = new KeycloakScripts((ScriptProviderDescriptor)JsonSerialization.readValue((InputStream)in, ScriptProviderDescriptor.class));
            List<ScriptProviderMetadata> authenticators = keycloakScripts3.getAuthenticators();
            List<ScriptProviderMetadata> oidcMappers = keycloakScripts3.getOidcMappers();
            List<ScriptProviderMetadata> policies = keycloakScripts3.getPolicies();
            log.info("Detected script-based components. authenticators={} mappers={} policies={}", new Object[]{authenticators.size(), oidcMappers.size(), policies.size()});
            KeycloakScripts keycloakScripts = keycloakScripts3;
            return keycloakScripts;
        }
        catch (IOException e) {
            log.info("Failed to load detect any script-based components on classpath from {}.", (Object)KEYCLOAK_SCRIPTS_JSON_LOCATION, (Object)e);
            return null;
        }
    }

    private void deployKeycloakScriptComponents(ProviderManagerDeployer factory, KeycloakScripts keycloakScripts) {
        KeycloakDeploymentInfo kdi = KeycloakDeploymentInfo.create().name("script-components");
        List<ScriptProviderMetadata> authenticators = keycloakScripts.getAuthenticators();
        authenticators.stream().map(this::initScriptComponent).forEach(sc -> kdi.addProvider(AuthenticatorSpi.class, (ProviderFactory)new DeployedScriptAuthenticatorFactory(sc)));
        List<ScriptProviderMetadata> oidcMappers = keycloakScripts.getOidcMappers();
        oidcMappers.stream().map(this::initScriptComponent).forEach(sc -> kdi.addProvider(ProtocolMapperSpi.class, (ProviderFactory)new DeployedScriptOIDCProtocolMapper(sc)));
        List<ScriptProviderMetadata> policies = keycloakScripts.getPolicies();
        policies.stream().map(this::initScriptComponent).forEach(sc -> kdi.addProvider(PolicySpi.class, (ProviderFactory)new DeployedScriptPolicyFactory(sc)));
        ProviderManager pm = new ProviderManager(kdi, Thread.currentThread().getContextClassLoader(), new String[0]);
        ProviderManagerRegistry.SINGLETON.setDeployer(factory);
        ProviderManagerRegistry.SINGLETON.deploy(pm);
    }

    private ScriptProviderMetadata initScriptComponent(ScriptProviderMetadata scriptMetadata) {
        scriptMetadata.setId("script-" + scriptMetadata.getFileName());
        String name = scriptMetadata.getName();
        if (name == null) {
            name = scriptMetadata.getFileName();
        }
        scriptMetadata.setName(name);
        String scriptLocation = "./scripts/" + scriptMetadata.getFileName();
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(scriptLocation);){
            scriptMetadata.setCode(StreamUtils.copyToString((InputStream)in, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            log.warn("Cannot load script from {}", (Object)scriptMetadata.getFileName());
        }
        return scriptMetadata;
    }

    public void close() {
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.SCRIPTS);
    }

    public String getDisplayType() {
        return null;
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return new AuthenticationExecutionModel.Requirement[0];
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return null;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }

    static class KeycloakScripts {
        private final ScriptProviderDescriptor descriptor;

        public List<ScriptProviderMetadata> getAuthenticators() {
            return Optional.ofNullable((List)this.descriptor.getProviders().get("authenticators")).orElse(Collections.emptyList());
        }

        public List<ScriptProviderMetadata> getOidcMappers() {
            return Optional.ofNullable((List)this.descriptor.getProviders().get("mappers")).orElse(Collections.emptyList());
        }

        public List<ScriptProviderMetadata> getPolicies() {
            return Optional.ofNullable((List)this.descriptor.getProviders().get("policies")).orElse(Collections.emptyList());
        }

        public KeycloakScripts(ScriptProviderDescriptor descriptor) {
            this.descriptor = descriptor;
        }
    }
}

