/*
 * Decompiled with CFR 0.152.
 */
package com.thomasbouvier.persistentcookiejar.persistence;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.thomasbouvier.persistentcookiejar.persistence.CookiePersistor;
import com.thomasbouvier.persistentcookiejar.persistence.SerializableCookie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import okhttp3.Cookie;

@SuppressLint(value={"CommitPrefEdits"})
public class SharedPrefsCookiePersistor
implements CookiePersistor {
    private final SharedPreferences sharedPreferences;

    public SharedPrefsCookiePersistor(Context context) {
        this(context.getSharedPreferences("CookiePersistence", 0));
    }

    public SharedPrefsCookiePersistor(SharedPreferences sharedPreferences) {
        this.sharedPreferences = sharedPreferences;
    }

    @Override
    public List<Cookie> loadAll() {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(this.sharedPreferences.getAll().size());
        for (Map.Entry entry : this.sharedPreferences.getAll().entrySet()) {
            Cookie cookie;
            String serializedCookie = (String)entry.getValue();
            if (serializedCookie == null || (cookie = new SerializableCookie().decode(serializedCookie)) == null) continue;
            cookies.add(cookie);
        }
        return cookies;
    }

    @Override
    public void saveAll(Collection<Cookie> cookies) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        for (Cookie cookie : cookies) {
            editor.putString(SharedPrefsCookiePersistor.createCookieKey(cookie), new SerializableCookie().encode(cookie));
        }
        editor.commit();
    }

    @Override
    public void removeAll(Collection<Cookie> cookies) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        for (Cookie cookie : cookies) {
            editor.remove(SharedPrefsCookiePersistor.createCookieKey(cookie));
        }
        editor.commit();
    }

    private static String createCookieKey(Cookie cookie) {
        return (cookie.secure() ? "https" : "http") + "://" + cookie.domain() + cookie.path() + "|" + cookie.name();
    }

    @Override
    public void clear() {
        this.sharedPreferences.edit().clear().commit();
    }
}

