/*
 * Decompiled with CFR 0.152.
 */
package com.pacific.timer;

import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

public final class Rx2Timer {
    private final long take;
    private final long period;
    private final long initialDelay;
    private final TimeUnit unit;
    private final Action onComplete;
    private final Consumer<Long> onEmit;
    private final Consumer<Throwable> onError;
    private long pauseTake = 0L;
    private long resumeTake = 0L;
    private boolean isPause = false;
    private boolean isStarted = false;
    private Disposable disposable;

    private Rx2Timer(Builder builder) {
        this.take = builder.take;
        this.period = builder.period;
        this.initialDelay = builder.initialDelay;
        this.unit = builder.unit;
        this.onComplete = builder.onComplete;
        this.onEmit = builder.onEmit;
        this.onError = builder.onError;
    }

    public boolean isPause() {
        return this.isPause;
    }

    public Rx2Timer restart() {
        this.stop();
        return this.start();
    }

    public Rx2Timer start() {
        if (this.isPause) {
            return this.restart();
        }
        if (this.disposable == null || this.disposable.isDisposed()) {
            this.disposable = Observable.interval((long)this.initialDelay, (long)this.period, (TimeUnit)this.unit).subscribeOn(Schedulers.single()).take(this.take + 1L).map((Function)new Function<Long, Long>(){

                public Long apply(Long aLong) throws Exception {
                    Rx2Timer.this.pauseTake = aLong;
                    return Rx2Timer.this.take - aLong;
                }
            }).doOnSubscribe((Consumer)new Consumer<Disposable>(){

                public void accept(Disposable disposable) throws Exception {
                    Rx2Timer.this.isStarted = true;
                }
            }).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    if (Rx2Timer.this.onEmit != null) {
                        Rx2Timer.this.onEmit.accept((Object)aLong);
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) throws Exception {
                    if (Rx2Timer.this.onError != null) {
                        Rx2Timer.this.onError.accept((Object)throwable);
                    }
                }
            }, new Action(){

                public void run() throws Exception {
                    if (Rx2Timer.this.onComplete != null) {
                        Rx2Timer.this.onComplete.run();
                    }
                }
            });
        }
        return this;
    }

    public void stop() {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
        if (this.isPause) {
            this.cleanPauseState();
        }
    }

    public void pause() {
        if (this.isPause || !this.isStarted) {
            return;
        }
        this.stop();
        this.isPause = true;
        this.resumeTake += this.pauseTake;
    }

    public void resume() {
        if (!this.isPause) {
            return;
        }
        this.isPause = false;
        if (this.disposable == null || this.disposable.isDisposed()) {
            this.disposable = Observable.interval((long)this.initialDelay, (long)this.period, (TimeUnit)this.unit).subscribeOn(Schedulers.single()).take(this.take + 1L - this.resumeTake).map((Function)new Function<Long, Long>(){

                public Long apply(Long aLong) throws Exception {
                    Rx2Timer.this.pauseTake = aLong;
                    return Rx2Timer.this.take - aLong - Rx2Timer.this.resumeTake;
                }
            }).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    if (Rx2Timer.this.onEmit != null) {
                        Rx2Timer.this.onEmit.accept((Object)aLong);
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) throws Exception {
                    Rx2Timer.this.cleanPauseState();
                    if (Rx2Timer.this.onError != null) {
                        Rx2Timer.this.onError.accept((Object)throwable);
                    }
                }
            }, new Action(){

                public void run() throws Exception {
                    Rx2Timer.this.cleanPauseState();
                    if (Rx2Timer.this.onComplete != null) {
                        Rx2Timer.this.onComplete.run();
                    }
                }
            });
        }
    }

    public void cleanPauseState() {
        this.isPause = false;
        this.resumeTake = 0L;
        this.pauseTake = 0L;
        this.isStarted = false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private long take = 60L;
        private long period = 1L;
        private long initialDelay = 0L;
        private TimeUnit unit = TimeUnit.SECONDS;
        private Action onComplete;
        private Consumer<Long> onEmit;
        private Consumer<Throwable> onError;

        Builder() {
        }

        public Builder take(int take) {
            this.take = take;
            return this;
        }

        public Builder period(int period) {
            this.period = period;
            return this;
        }

        public Builder initialDelay(int initialDelay) {
            this.initialDelay = initialDelay;
            return this;
        }

        public Builder unit(TimeUnit unit) {
            this.unit = unit;
            return this;
        }

        public Builder onComplete(Action onComplete) {
            this.onComplete = onComplete;
            return this;
        }

        public Builder onEmit(Consumer<Long> onEmit) {
            this.onEmit = onEmit;
            return this;
        }

        public Builder onError(Consumer<Throwable> onError) {
            this.onError = onError;
            return this;
        }

        public Rx2Timer build() {
            return new Rx2Timer(this);
        }
    }
}

