/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjust.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.thekhaeng.library.uiadjust.adapter.holder.BaseAdjustViewHolder;
import com.thekhaeng.library.uiadjust.adapter.holder.BooleanAdjustHolder;
import com.thekhaeng.library.uiadjust.adapter.holder.ColorAdjustHolder;
import com.thekhaeng.library.uiadjust.adapter.holder.IntegerAdjustHolder;
import com.thekhaeng.library.uiadjust.adapter.holder.RangeFloatAdjustHolder;
import com.thekhaeng.library.uiadjust.adapter.holder.StringAdjustHolder;
import com.thekhaeng.library.uiadjust.adapter.item.BaseAdjustItem;
import com.thekhaeng.library.uiadjust.adapter.item.BooleanAdjustment;
import com.thekhaeng.library.uiadjust.adapter.item.ColorAdjustment;
import com.thekhaeng.library.uiadjust.adapter.item.IntegerAdjustment;
import com.thekhaeng.library.uiadjust.adapter.item.RangeFloatAdjustment;
import com.thekhaeng.library.uiadjust.adapter.item.StringAdjustment;
import java.util.ArrayList;
import java.util.List;

public class AdjustAdapter
extends RecyclerView.Adapter<BaseAdjustViewHolder> {
    public static final int BOOLEAN_ITEM = 1;
    public static final int COLOR_ITEM = 2;
    public static final int INTEGER_ITEM = 3;
    public static final int RANGE_FLOAT_ITEM = 4;
    public static final int STRING_ITEM = 5;
    private List<BaseAdjustItem> itemList = new ArrayList<BaseAdjustItem>();

    public void setItemList(List<BaseAdjustItem> itemList) {
        if (itemList == null || itemList.isEmpty()) {
            return;
        }
        this.itemList = itemList;
        this.notifyDataSetChanged();
    }

    public void updateItemList(List<BaseAdjustItem> itemList) {
        for (int i = 0; i < itemList.size(); ++i) {
            this.itemList.set(i, itemList.get(i));
            this.notifyItemChanged(i);
        }
    }

    public List<BaseAdjustItem> getItemList() {
        return this.itemList;
    }

    public int getItemCount() {
        return this.itemList.size();
    }

    public int getItemViewType(int position) {
        return this.itemList.get(position).getType();
    }

    public BaseAdjustViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1) {
            return new BooleanAdjustHolder(parent);
        }
        if (viewType == 2) {
            return new ColorAdjustHolder(parent);
        }
        if (viewType == 3) {
            return new IntegerAdjustHolder(parent);
        }
        if (viewType == 4) {
            return new RangeFloatAdjustHolder(parent);
        }
        if (viewType == 5) {
            return new StringAdjustHolder(parent);
        }
        return null;
    }

    public void onBindViewHolder(BaseAdjustViewHolder vh, int position) {
        BaseAdjustItem i = this.itemList.get(position);
        if (this.getItemViewType(position) == 1) {
            BooleanAdjustHolder holder = (BooleanAdjustHolder)vh;
            BooleanAdjustment item = (BooleanAdjustment)i;
            holder.onBind(item);
        } else if (this.getItemViewType(position) == 2) {
            ColorAdjustHolder holder = (ColorAdjustHolder)vh;
            ColorAdjustment item = (ColorAdjustment)i;
            holder.onBind(item);
        } else if (this.getItemViewType(position) == 3) {
            IntegerAdjustHolder holder = (IntegerAdjustHolder)vh;
            IntegerAdjustment item = (IntegerAdjustment)i;
            holder.onBind(item);
        } else if (this.getItemViewType(position) == 4) {
            RangeFloatAdjustHolder holder = (RangeFloatAdjustHolder)vh;
            RangeFloatAdjustment item = (RangeFloatAdjustment)i;
            holder.onBind(item);
        } else if (this.getItemViewType(position) == 5) {
            StringAdjustHolder holder = (StringAdjustHolder)vh;
            StringAdjustment item = (StringAdjustment)i;
            holder.onBind(item);
        }
    }
}

