/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjust;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.BottomSheetDialogFragment;
import android.support.design.widget.CoordinatorLayout;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.AppCompatTextView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.thekhaeng.library.uiadjust.R;
import com.thekhaeng.library.uiadjust.adapter.AdjustAdapter;
import com.thekhaeng.library.uiadjust.adapter.item.BaseAdjustItem;
import java.util.ArrayList;
import java.util.List;

public class UIAdjustBottomSheet
extends BottomSheetDialogFragment {
    public static final String KEY_DEFAULT_ITEM_LIST = "key_default_item_list";
    public static final String KEY_LOADED_ITEM_LIST = "key_loaded_item_list";
    private static final int CANCEL = 1;
    private static final int DONE = 2;
    private AppCompatImageView btnCancel;
    private AppCompatImageView btnDone;
    private AppCompatImageView btnReset;
    private AppCompatTextView tvTitle;
    private RecyclerView rvAdjust;
    private LinearLayoutManager layoutManager;
    private AdjustAdapter adapter;
    private OnDismissBottomSheetListener dismissListener;
    private int exitState = 1;
    private long delay = 0L;

    public static UIAdjustBottomSheet create(List<BaseAdjustItem> defaultItemList, List<BaseAdjustItem> loadedItemList) {
        UIAdjustBottomSheet fragment = new UIAdjustBottomSheet();
        Bundle args = new Bundle();
        args.putParcelableArrayList(KEY_DEFAULT_ITEM_LIST, (ArrayList)defaultItemList);
        args.putParcelableArrayList(KEY_LOADED_ITEM_LIST, (ArrayList)loadedItemList);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.cancel();
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    public void setupDialog(Dialog dialog, int style) {
        super.setupDialog(dialog, style);
        View contentView = View.inflate((Context)this.getContext(), (int)R.layout.library_bottom_sheet_ui_adjust, null);
        dialog.setContentView(contentView);
        CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams)((View)contentView.getParent()).getLayoutParams();
        final CoordinatorLayout.Behavior behavior = params.getBehavior();
        if (behavior != null && behavior instanceof BottomSheetBehavior) {
            ((BottomSheetBehavior)behavior).setBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback(){

                public void onStateChanged(@NonNull View bottomSheet, int newState) {
                    if (newState == 5) {
                        UIAdjustBottomSheet.this.dismiss();
                        ((BottomSheetBehavior)behavior).setState(4);
                    }
                }

                public void onSlide(@NonNull View bottomSheet, float slideOffset) {
                }
            });
        }
        this.onBindView(contentView);
        this.setupView();
    }

    public void onDismiss(DialogInterface dialog) {
        if (this.dismissListener != null) {
            if (this.exitState == 1) {
                this.dismissListener.onCancel();
            } else if (this.exitState == 2) {
                if (this.delay > 0L) {
                    this.delay(new Runnable(){

                        @Override
                        public void run() {
                            UIAdjustBottomSheet.this.dismissListener.onDone(UIAdjustBottomSheet.this.adapter.getItemList());
                        }
                    }, this.delay);
                } else {
                    this.dismissListener.onDone(this.adapter.getItemList());
                }
            }
        }
        super.onDismiss(dialog);
    }

    private void reset() {
        ArrayList<BaseAdjustItem> copyItemList = new ArrayList<BaseAdjustItem>();
        for (BaseAdjustItem item : this.getDefaultItemList()) {
            copyItemList.add(item.copy());
        }
        this.adapter.updateItemList(copyItemList);
    }

    private void cancel() {
        this.exitState = 1;
        this.dismiss();
    }

    private void done() {
        this.exitState = 2;
        this.dismiss();
    }

    private void onBindView(View view) {
        this.btnCancel = (AppCompatImageView)view.findViewById(R.id.library_btn_cancel);
        this.tvTitle = (AppCompatTextView)view.findViewById(R.id.library_tv_title);
        this.btnDone = (AppCompatImageView)view.findViewById(R.id.library_btn_done);
        this.btnReset = (AppCompatImageView)view.findViewById(R.id.library_btn_reset);
        this.rvAdjust = (RecyclerView)view.findViewById(R.id.library_rv_adjust);
        this.btnCancel.setOnClickListener(this.setOnClickListener());
        this.btnDone.setOnClickListener(this.setOnClickListener());
        this.btnReset.setOnClickListener(this.setOnClickListener());
    }

    private void setupView() {
        this.layoutManager = new LinearLayoutManager(this.getContext());
        this.adapter = new AdjustAdapter();
        this.rvAdjust.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.rvAdjust.setAdapter((RecyclerView.Adapter)this.adapter);
        this.adapter.setItemList(this.getLoadedItemList());
    }

    public void setDelayTime(long delay) {
        this.delay = delay;
    }

    public void setOnDismissBottomSheetListener(OnDismissBottomSheetListener dismissListener) {
        this.dismissListener = dismissListener;
    }

    public List<BaseAdjustItem> getDefaultItemList() {
        return this.getItemList(KEY_DEFAULT_ITEM_LIST);
    }

    public List<BaseAdjustItem> getLoadedItemList() {
        return this.getItemList(KEY_LOADED_ITEM_LIST);
    }

    public List<BaseAdjustItem> getItemList(String key) {
        if (this.getArguments() != null) {
            ArrayList itemList = this.getArguments().getParcelableArrayList(key);
            if (itemList != null) {
                return itemList;
            }
            return new ArrayList<BaseAdjustItem>();
        }
        return new ArrayList<BaseAdjustItem>();
    }

    private void delay(Runnable runnable, long delay) {
        Handler handler = new Handler();
        handler.postDelayed(runnable, delay);
    }

    @NonNull
    private View.OnClickListener setOnClickListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                if (v == UIAdjustBottomSheet.this.btnCancel) {
                    UIAdjustBottomSheet.this.cancel();
                } else if (v == UIAdjustBottomSheet.this.btnReset) {
                    UIAdjustBottomSheet.this.reset();
                } else if (v == UIAdjustBottomSheet.this.btnDone) {
                    UIAdjustBottomSheet.this.done();
                }
            }
        };
    }

    static interface OnDismissBottomSheetListener {
        public void onDone(List<BaseAdjustItem> var1);

        public void onCancel();
    }
}

