/*
 * Decompiled with CFR 0.152.
 */
package com.thegrizzlylabs.sardineandroid.impl;

import android.text.TextUtils;
import com.thegrizzlylabs.sardineandroid.DavAce;
import com.thegrizzlylabs.sardineandroid.DavAcl;
import com.thegrizzlylabs.sardineandroid.DavPrincipal;
import com.thegrizzlylabs.sardineandroid.DavQuota;
import com.thegrizzlylabs.sardineandroid.DavResource;
import com.thegrizzlylabs.sardineandroid.Sardine;
import com.thegrizzlylabs.sardineandroid.impl.BasicAuthenticator;
import com.thegrizzlylabs.sardineandroid.impl.handler.ExistsResponseHandler;
import com.thegrizzlylabs.sardineandroid.impl.handler.InputStreamResponseHandler;
import com.thegrizzlylabs.sardineandroid.impl.handler.LockResponseHandler;
import com.thegrizzlylabs.sardineandroid.impl.handler.MultiStatusResponseHandler;
import com.thegrizzlylabs.sardineandroid.impl.handler.ResourcesResponseHandler;
import com.thegrizzlylabs.sardineandroid.impl.handler.ResponseHandler;
import com.thegrizzlylabs.sardineandroid.impl.handler.VoidResponseHandler;
import com.thegrizzlylabs.sardineandroid.model.Ace;
import com.thegrizzlylabs.sardineandroid.model.Acl;
import com.thegrizzlylabs.sardineandroid.model.Allprop;
import com.thegrizzlylabs.sardineandroid.model.Exclusive;
import com.thegrizzlylabs.sardineandroid.model.Group;
import com.thegrizzlylabs.sardineandroid.model.Lockinfo;
import com.thegrizzlylabs.sardineandroid.model.Lockscope;
import com.thegrizzlylabs.sardineandroid.model.Locktype;
import com.thegrizzlylabs.sardineandroid.model.Multistatus;
import com.thegrizzlylabs.sardineandroid.model.Owner;
import com.thegrizzlylabs.sardineandroid.model.PrincipalCollectionSet;
import com.thegrizzlylabs.sardineandroid.model.Prop;
import com.thegrizzlylabs.sardineandroid.model.Propertyupdate;
import com.thegrizzlylabs.sardineandroid.model.Propfind;
import com.thegrizzlylabs.sardineandroid.model.Propstat;
import com.thegrizzlylabs.sardineandroid.model.QuotaAvailableBytes;
import com.thegrizzlylabs.sardineandroid.model.QuotaUsedBytes;
import com.thegrizzlylabs.sardineandroid.model.Remove;
import com.thegrizzlylabs.sardineandroid.model.Response;
import com.thegrizzlylabs.sardineandroid.model.SearchRequest;
import com.thegrizzlylabs.sardineandroid.model.Set;
import com.thegrizzlylabs.sardineandroid.model.Write;
import com.thegrizzlylabs.sardineandroid.report.SardineReport;
import com.thegrizzlylabs.sardineandroid.util.SardineUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.w3c.dom.Element;

public class OkHttpSardine
implements Sardine {
    private OkHttpClient client;

    public OkHttpSardine() {
        this.client = new OkHttpClient.Builder().build();
    }

    public OkHttpSardine(OkHttpClient client) {
        this.client = client;
    }

    @Override
    public void setCredentials(String username, String password, boolean isPreemptive) {
        OkHttpClient.Builder builder = this.client.newBuilder();
        if (isPreemptive) {
            builder.addInterceptor((Interceptor)new AuthenticationInterceptor(username, password));
        } else {
            builder.authenticator((Authenticator)new BasicAuthenticator(username, password));
        }
        this.client = builder.build();
    }

    @Override
    public void setCredentials(String username, String password) {
        this.setCredentials(username, password, false);
    }

    @Override
    public List<DavResource> getResources(String url) throws IOException {
        return this.list(url);
    }

    @Override
    public List<DavResource> list(String url) throws IOException {
        return this.list(url, 1);
    }

    @Override
    public List<DavResource> list(String url, int depth) throws IOException {
        return this.list(url, depth, true);
    }

    @Override
    public List<DavResource> list(String url, int depth, java.util.Set<QName> props) throws IOException {
        Propfind body = new Propfind();
        Prop prop = new Prop();
        this.addCustomProperties(prop, props);
        body.setProp(prop);
        return this.propfind(url, depth, body);
    }

    @Override
    public List<DavResource> list(String url, int depth, boolean allProp) throws IOException {
        if (allProp) {
            Propfind body = new Propfind();
            body.setAllprop(new Allprop());
            return this.propfind(url, depth, body);
        }
        return this.list(url, depth, Collections.emptySet());
    }

    @Override
    public List<DavResource> propfind(String url, int depth, java.util.Set<QName> props) throws IOException {
        Propfind body = new Propfind();
        Prop prop = new Prop();
        this.addCustomProperties(prop, props);
        body.setProp(prop);
        return this.propfind(url, depth, body);
    }

    private void addCustomProperties(Prop prop, java.util.Set<QName> props) {
        List<Element> any = prop.getAny();
        for (QName entry : props) {
            Element element = SardineUtil.createElement(entry);
            any.add(element);
        }
    }

    protected List<DavResource> propfind(String url, int depth, Propfind body) throws IOException {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/xml"), (String)SardineUtil.toXml(body));
        Request request = new Request.Builder().url(url).header("Depth", depth < 0 ? "infinity" : Integer.toString(depth)).method("PROPFIND", requestBody).build();
        return this.execute(request, new ResourcesResponseHandler());
    }

    @Override
    public <T> T report(String url, int depth, SardineReport<T> report) throws IOException {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/xml"), (String)report.toXml());
        Request request = new Request.Builder().url(url).header("Depth", depth < 0 ? "infinity" : Integer.toString(depth)).method("REPORT", requestBody).build();
        Multistatus multistatus = this.execute(request, new MultiStatusResponseHandler());
        return report.fromMultistatus(multistatus);
    }

    @Override
    public List<DavResource> search(String url, String language, String query) throws IOException {
        SearchRequest searchBody = new SearchRequest(language, query);
        String body = SardineUtil.toXml(searchBody);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/xml"), (String)SardineUtil.toXml(body));
        Request request = new Request.Builder().url(url).method("SEARCH", requestBody).build();
        return this.execute(request, new ResourcesResponseHandler());
    }

    @Override
    public void setCustomProps(String url, Map<String, String> set, List<String> remove) throws IOException {
        this.patch(url, SardineUtil.toQName(set), SardineUtil.toQName(remove));
    }

    @Override
    public List<DavResource> patch(String url, Map<QName, String> setProps) throws IOException {
        return this.patch(url, setProps, Collections.emptyList());
    }

    @Override
    public List<DavResource> patch(String url, Map<QName, String> setProps, List<QName> removeProps) throws IOException {
        ArrayList<Element> setPropsElements = new ArrayList<Element>();
        for (Map.Entry<QName, String> entry : setProps.entrySet()) {
            Element element = SardineUtil.createElement(entry.getKey());
            element.setTextContent(entry.getValue());
            setPropsElements.add(element);
        }
        return this.patch(url, setPropsElements, removeProps);
    }

    @Override
    public List<DavResource> patch(String url, List<Element> setProps, List<QName> removeProps) throws IOException {
        Propertyupdate body = new Propertyupdate();
        Set set = new Set();
        body.getRemoveOrSet().add(set);
        Prop prop = new Prop();
        List<Element> any = prop.getAny();
        any.addAll(setProps);
        set.setProp(prop);
        Remove remove = new Remove();
        body.getRemoveOrSet().add(remove);
        prop = new Prop();
        any = prop.getAny();
        for (QName entry : removeProps) {
            Element element = SardineUtil.createElement(entry);
            any.add(element);
        }
        remove.setProp(prop);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/xml"), (String)SardineUtil.toXml(body));
        Request request = new Request.Builder().url(url).method("PROPPATCH", requestBody).build();
        return this.execute(request, new ResourcesResponseHandler());
    }

    @Override
    public InputStream get(String url) throws IOException {
        return this.get(url, Collections.emptyMap());
    }

    @Override
    public InputStream get(String url, Map<String, String> headers) throws IOException {
        return this.get(url, Headers.of(headers));
    }

    public InputStream get(String url, Headers headers) throws IOException {
        Request request = new Request.Builder().url(url).get().headers(headers).build();
        return this.execute(request, new InputStreamResponseHandler());
    }

    @Override
    public void put(String url, byte[] data) throws IOException {
        this.put(url, data, null);
    }

    @Override
    public void put(String url, byte[] data, String contentType) throws IOException {
        MediaType mediaType = contentType == null ? null : MediaType.parse((String)contentType);
        RequestBody requestBody = RequestBody.create((MediaType)mediaType, (byte[])data);
        this.put(url, requestBody);
    }

    @Override
    public void put(String url, File localFile, String contentType) throws IOException {
        this.put(url, localFile, contentType, false);
    }

    @Override
    public void put(String url, File localFile, String contentType, boolean expectContinue) throws IOException {
        this.put(url, localFile, contentType, expectContinue, null);
    }

    @Override
    public void put(String url, File localFile, String contentType, boolean expectContinue, String lockToken) throws IOException {
        MediaType mediaType = contentType == null ? null : MediaType.parse((String)contentType);
        RequestBody requestBody = RequestBody.create((MediaType)mediaType, (File)localFile);
        Headers.Builder headersBuilder = new Headers.Builder();
        if (expectContinue) {
            headersBuilder.add("Expect", "100-Continue");
        }
        if (!TextUtils.isEmpty((CharSequence)lockToken)) {
            this.addLockTokenToHeaders(headersBuilder, url, lockToken);
        }
        this.put(url, requestBody, headersBuilder.build());
    }

    private void put(String url, RequestBody requestBody) throws IOException {
        this.put(url, requestBody, new Headers.Builder().build());
    }

    private void put(String url, RequestBody requestBody, Headers headers) throws IOException {
        Request request = new Request.Builder().url(url).put(requestBody).headers(headers).build();
        this.execute(request);
    }

    @Override
    public void delete(String url) throws IOException {
        Request request = new Request.Builder().url(url).delete().build();
        this.execute(request);
    }

    @Override
    public void createDirectory(String url) throws IOException {
        Request request = new Request.Builder().url(url).method("MKCOL", null).build();
        this.execute(request);
    }

    @Override
    public void move(String sourceUrl, String destinationUrl) throws IOException {
        this.move(sourceUrl, destinationUrl, true);
    }

    @Override
    public void move(String sourceUrl, String destinationUrl, boolean overwrite) throws IOException {
        this.move(sourceUrl, destinationUrl, overwrite, null);
    }

    @Override
    public void move(String sourceUrl, String destinationUrl, boolean overwrite, String lockToken) throws IOException {
        Request.Builder builder = new Request.Builder().url(sourceUrl).method("MOVE", null);
        Headers.Builder headersBuilder = new Headers.Builder();
        headersBuilder.add("DESTINATION", URI.create(destinationUrl).toASCIIString());
        headersBuilder.add("OVERWRITE", overwrite ? "T" : "F");
        if (lockToken != null) {
            this.addLockTokenToHeaders(headersBuilder, destinationUrl, lockToken);
        }
        builder.headers(headersBuilder.build());
        Request request = builder.build();
        this.execute(request);
    }

    private void addLockTokenToHeaders(Headers.Builder headersBuilder, String destinationUrl, String lockToken) {
        headersBuilder.add("If", "<" + destinationUrl + "> (<" + lockToken + ">)");
    }

    @Override
    public void copy(String sourceUrl, String destinationUrl) throws IOException {
        this.copy(sourceUrl, destinationUrl, true);
    }

    @Override
    public void copy(String sourceUrl, String destinationUrl, boolean overwrite) throws IOException {
        Request request = new Request.Builder().url(sourceUrl).method("COPY", null).header("DESTINATION", URI.create(destinationUrl).toASCIIString()).header("OVERWRITE", overwrite ? "T" : "F").build();
        this.execute(request);
    }

    @Override
    public boolean exists(String url) throws IOException {
        Request request = new Request.Builder().url(url).header("Depth", "0").method("PROPFIND", null).build();
        return this.execute(request, new ExistsResponseHandler());
    }

    @Override
    public String lock(String url) throws IOException {
        return this.lock(url, 0);
    }

    @Override
    public String lock(String url, int timeout) throws IOException {
        Lockinfo body = new Lockinfo();
        Lockscope scopeType = new Lockscope();
        scopeType.setExclusive(new Exclusive());
        body.setLockscope(scopeType);
        Locktype lockType = new Locktype();
        lockType.setWrite(new Write());
        body.setLocktype(lockType);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/xml"), (String)SardineUtil.toXml(body));
        Request.Builder builder = new Request.Builder().url(url).method("LOCK", requestBody);
        if (timeout > 0) {
            builder.header("Timeout", "Second-" + timeout);
        }
        Request request = builder.build();
        return this.execute(request, new LockResponseHandler());
    }

    @Override
    public String refreshLock(String url, String token, String file) throws IOException {
        Request request = new Request.Builder().url(url).method("LOCK", null).header("If", "<" + file + "> (<" + token + ">)").build();
        return this.execute(request, new LockResponseHandler());
    }

    @Override
    public void unlock(String url, String token) throws IOException {
        Request request = new Request.Builder().url(url).method("UNLOCK", null).header("Lock-Token", "<" + token + ">").build();
        this.execute(request, new VoidResponseHandler());
    }

    @Override
    public DavAcl getAcl(String url) throws IOException {
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setOwner(new Owner());
        prop.setGroup(new Group());
        prop.setAcl(new Acl());
        body.setProp(prop);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/xml"), (String)SardineUtil.toXml(body));
        Request request = new Request.Builder().url(url).header("Depth", "0").method("PROPFIND", requestBody).build();
        Multistatus multistatus = this.execute(request, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        return new DavAcl(responses.get(0));
    }

    @Override
    public DavQuota getQuota(String url) throws IOException {
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setQuotaAvailableBytes(new QuotaAvailableBytes());
        prop.setQuotaUsedBytes(new QuotaUsedBytes());
        body.setProp(prop);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/xml"), (String)SardineUtil.toXml(body));
        Request request = new Request.Builder().url(url).header("Depth", "0").method("PROPFIND", requestBody).build();
        Multistatus multistatus = this.execute(request, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        return new DavQuota(responses.get(0));
    }

    @Override
    public void setAcl(String url, List<DavAce> aces) throws IOException {
        Acl body = new Acl();
        body.setAce(new ArrayList<Ace>());
        for (DavAce davAce : aces) {
            if (davAce.getInherited() != null || davAce.isProtected()) continue;
            Ace ace = davAce.toModel();
            body.getAce().add(ace);
        }
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/xml"), (String)SardineUtil.toXml(body));
        Request request = new Request.Builder().url(url).method("ACL", requestBody).build();
        this.execute(request, new VoidResponseHandler());
    }

    @Override
    public List<DavPrincipal> getPrincipals(String url) throws IOException {
        Propfind body = new Propfind();
        Prop prop = new Prop();
        body.setProp(prop);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/xml"), (String)SardineUtil.toXml(body));
        Request request = new Request.Builder().url(url).header("Depth", "1").method("PROPFIND", requestBody).build();
        Multistatus multistatus = this.execute(request, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        ArrayList<DavPrincipal> collections = new ArrayList<DavPrincipal>();
        for (Response r : responses) {
            if (r.getPropstat() == null) continue;
            for (Propstat propstat : r.getPropstat()) {
                if (propstat.getProp() == null || propstat.getProp().getResourcetype() == null || propstat.getProp().getResourcetype().getPrincipal() == null) continue;
                collections.add(new DavPrincipal(DavPrincipal.PrincipalType.HREF, r.getHref(), propstat.getProp().getDisplayname()));
            }
        }
        return collections;
    }

    @Override
    public List<String> getPrincipalCollectionSet(String url) throws IOException {
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setPrincipalCollectionSet(new PrincipalCollectionSet());
        body.setProp(prop);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/xml"), (String)SardineUtil.toXml(body));
        Request request = new Request.Builder().url(url).header("Depth", "0").method("PROPFIND", requestBody).build();
        Multistatus multistatus = this.execute(request, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        ArrayList<String> collections = new ArrayList<String>();
        for (Response r : responses) {
            if (r.getPropstat() == null) continue;
            for (Propstat propstat : r.getPropstat()) {
                if (propstat.getProp() == null || propstat.getProp().getPrincipalCollectionSet() == null || propstat.getProp().getPrincipalCollectionSet().getHref() == null) continue;
                collections.add(propstat.getProp().getPrincipalCollectionSet().getHref());
            }
        }
        return collections;
    }

    @Override
    public void enableCompression() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disableCompression() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ignoreCookies() {
        throw new UnsupportedOperationException();
    }

    private void execute(Request request) throws IOException {
        this.execute(request, new VoidResponseHandler());
    }

    private <T> T execute(Request request, ResponseHandler<T> responseHandler) throws IOException {
        okhttp3.Response response = this.client.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    private class AuthenticationInterceptor
    implements Interceptor {
        private String userName;
        private String password;

        public AuthenticationInterceptor(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        public okhttp3.Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request().newBuilder().addHeader("Authorization", Credentials.basic((String)this.userName, (String)this.password, (Charset)SardineUtil.standardUTF8())).build();
            return chain.proceed(request);
        }
    }
}

