/*
 * Decompiled with CFR 0.152.
 */
package com.thegrizzlylabs.sardineandroid;

import com.thegrizzlylabs.sardineandroid.DavPrincipal;
import com.thegrizzlylabs.sardineandroid.model.Ace;
import com.thegrizzlylabs.sardineandroid.model.All;
import com.thegrizzlylabs.sardineandroid.model.Authenticated;
import com.thegrizzlylabs.sardineandroid.model.Bind;
import com.thegrizzlylabs.sardineandroid.model.Deny;
import com.thegrizzlylabs.sardineandroid.model.Grant;
import com.thegrizzlylabs.sardineandroid.model.Principal;
import com.thegrizzlylabs.sardineandroid.model.Privilege;
import com.thegrizzlylabs.sardineandroid.model.Property;
import com.thegrizzlylabs.sardineandroid.model.Read;
import com.thegrizzlylabs.sardineandroid.model.ReadAcl;
import com.thegrizzlylabs.sardineandroid.model.ReadCurrentUserPrivilegeSet;
import com.thegrizzlylabs.sardineandroid.model.Self;
import com.thegrizzlylabs.sardineandroid.model.SimplePrivilege;
import com.thegrizzlylabs.sardineandroid.model.UnBind;
import com.thegrizzlylabs.sardineandroid.model.Unauthenticated;
import com.thegrizzlylabs.sardineandroid.model.Unlock;
import com.thegrizzlylabs.sardineandroid.model.Write;
import com.thegrizzlylabs.sardineandroid.model.WriteContent;
import com.thegrizzlylabs.sardineandroid.model.WriteProperties;
import com.thegrizzlylabs.sardineandroid.util.SardineUtil;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Root;

public class DavAce {
    private final DavPrincipal principal;
    private final List<String> granted;
    private final List<String> denied;
    private final String inherited;
    private final boolean isprotected;

    public DavAce(DavPrincipal principal) {
        this.principal = principal;
        this.granted = new ArrayList<String>();
        this.denied = new ArrayList<String>();
        this.inherited = null;
        this.isprotected = false;
    }

    public DavAce(Ace ace) {
        this.principal = new DavPrincipal(ace.getPrincipal());
        this.granted = new ArrayList<String>();
        this.denied = new ArrayList<String>();
        if (ace.getGrant() != null) {
            for (Privilege p : ace.getGrant().getPrivilege()) {
                for (SimplePrivilege o : p.getContent()) {
                    this.granted.add(o.getClass().getAnnotation(Root.class).name());
                }
            }
        }
        if (ace.getDeny() != null) {
            for (Privilege p : ace.getDeny().getPrivilege()) {
                for (SimplePrivilege o : p.getContent()) {
                    this.denied.add(o.getClass().getAnnotation(Root.class).name());
                }
            }
        }
        this.inherited = ace.getInherited() != null ? ace.getInherited().getHref() : null;
        this.isprotected = ace.getProtected() != null;
    }

    public DavPrincipal getPrincipal() {
        return this.principal;
    }

    public List<String> getGranted() {
        return this.granted;
    }

    public List<String> getDenied() {
        return this.denied;
    }

    public String getInherited() {
        return this.inherited;
    }

    public boolean isProtected() {
        return this.isprotected;
    }

    public Ace toModel() {
        Ace ace = new Ace();
        Principal p = new Principal();
        switch (this.principal.getPrincipalType()) {
            case HREF: {
                p.setHref(this.principal.getValue());
                break;
            }
            case PROPERTY: {
                p.setProperty(new Property());
                p.getProperty().setProperty(SardineUtil.createElement(this.principal.getProperty()));
                break;
            }
            case KEY: {
                if ("all".equals(this.principal.getValue())) {
                    p.setAll(new All());
                    break;
                }
                if ("authenticated".equals(this.principal.getValue())) {
                    p.setAuthenticated(new Authenticated());
                    break;
                }
                if ("unauthenticated".equals(this.principal.getValue())) {
                    p.setUnauthenticated(new Unauthenticated());
                    break;
                }
                if (!"self".equals(this.principal.getValue())) break;
                p.setSelf(new Self());
            }
        }
        ace.setPrincipal(p);
        if (this.granted != null && this.granted.size() > 0) {
            ace.setGrant(new Grant());
            ace.getGrant().setPrivilege(this.toPrivilege(this.granted));
        }
        if (this.denied != null && this.denied.size() > 0) {
            ace.setDeny(new Deny());
            ace.getDeny().setPrivilege(this.toPrivilege(this.denied));
        }
        return ace;
    }

    private List<Privilege> toPrivilege(List<String> rights) {
        ArrayList<Privilege> privileges = new ArrayList<Privilege>();
        for (String right : rights) {
            Privilege p = new Privilege();
            if ("all".equals(right)) {
                p.getContent().add(new All());
            } else if ("bind".equals(right)) {
                p.getContent().add(new Bind());
            } else if ("read".equals(right)) {
                p.getContent().add(new Read());
            } else if ("read-acl".equals(right)) {
                p.getContent().add(new ReadAcl());
            } else if ("read-current-user-privilege-set".equals(right)) {
                p.getContent().add(new ReadCurrentUserPrivilegeSet());
            } else if ("unbind".equals(right)) {
                p.getContent().add(new UnBind());
            } else if ("unlock".equals(right)) {
                p.getContent().add(new Unlock());
            } else if ("write".equals(right)) {
                p.getContent().add(new Write());
            } else if ("write-content".equals(right)) {
                p.getContent().add(new WriteContent());
            } else {
                if (!"write-properties".equals(right)) continue;
                p.getContent().add(new WriteProperties());
            }
            privileges.add(p);
        }
        return privileges;
    }
}

