/*
 * Decompiled with CFR 0.152.
 */
package at.pollux.thymeleaf.shiro.processor.element;

import at.pollux.thymeleaf.shiro.dialect.ShiroFacade;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.element.AbstractConditionalVisibilityElementProcessor;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public class HasPermissionElementProcessor
extends AbstractConditionalVisibilityElementProcessor {
    private static final String ELEMENT_NAME = "haspermission";
    private static final int PRECEDENCE = 300;

    public static HasPermissionElementProcessor create() {
        return new HasPermissionElementProcessor();
    }

    protected HasPermissionElementProcessor() {
        super(ELEMENT_NAME);
    }

    public int getPrecedence() {
        return 300;
    }

    public boolean removeHostElementIfVisible(Arguments arguments, Element element) {
        return true;
    }

    public boolean isVisible(Arguments arguments, Element element) {
        Validate.notNull((Object)element, (String)"element must not be null");
        String permission = StringUtils.trim((Object)element.getAttributeValue("name"));
        Validate.notEmpty((String)permission, (String)"value of 'name' must not be empty");
        return ShiroFacade.hasPermission(permission);
    }
}

