/*
 * Decompiled with CFR 0.152.
 */
package at.pollux.thymeleaf.shiro.dialect;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.apache.shiro.SecurityUtils;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class ShiroFacade {
    public static boolean isAuthenticated() {
        return SecurityUtils.getSubject() != null && SecurityUtils.getSubject().isAuthenticated();
    }

    public static boolean isNotAuthenticated() {
        return !ShiroFacade.isAuthenticated();
    }

    public static boolean isUser() {
        return SecurityUtils.getSubject() != null && SecurityUtils.getSubject().getPrincipal() != null;
    }

    public static boolean isGuest() {
        return !ShiroFacade.isUser();
    }

    public static boolean hasPermission(String p) {
        return SecurityUtils.getSubject() != null && SecurityUtils.getSubject().isPermitted(p);
    }

    public static boolean lacksPermission(String p) {
        return !ShiroFacade.hasPermission(p);
    }

    public static boolean hasRole(String roleName) {
        return SecurityUtils.getSubject() != null && SecurityUtils.getSubject().hasRole(roleName);
    }

    public static boolean lacksRole(String roleName) {
        return !ShiroFacade.hasRole(roleName);
    }

    public static boolean hasAnyRoles(String ... roles) {
        if (SecurityUtils.getSubject() != null) {
            for (String role : roles) {
                if (!SecurityUtils.getSubject().hasRole(StringUtils.trim((Object)role))) continue;
                return true;
            }
        }
        return false;
    }

    public static String getPrincipalText(String type, String property) {
        if (SecurityUtils.getSubject() == null) {
            return "";
        }
        Object principal = SecurityUtils.getSubject().getPrincipal();
        if (type != null || property != null) {
            if (type != null) {
                principal = ShiroFacade.getPrincipalFromClassName(type);
            }
            if (principal != null) {
                return property == null ? principal.toString() : ShiroFacade.getPrincipalProperty(principal, property);
            }
        }
        return principal != null ? principal.toString() : "";
    }

    public static Object getPrincipalFromClassName(String type) {
        Object principal = null;
        try {
            Class<?> cls = Class.forName(type);
            principal = SecurityUtils.getSubject().getPrincipals().oneByType(cls);
        }
        catch (ClassNotFoundException e) {
            Validate.isTrue((boolean)false, (String)("Unable to find class for name [" + type + "]"));
        }
        return principal;
    }

    public static String getPrincipalProperty(Object principal, String property) {
        try {
            BeanInfo bi = Introspector.getBeanInfo(principal.getClass());
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                if (!pd.getName().equals(property)) continue;
                Object value = pd.getReadMethod().invoke(principal, (Object[])null);
                return String.valueOf(value);
            }
        }
        catch (Exception e) {
            Validate.isTrue((boolean)false, (String)("Error reading property [" + property + "] from principal of type [" + principal.getClass().getName() + "]"));
        }
        Validate.isTrue((boolean)false, (String)("Property [" + property + "] not found in principal of type [" + principal.getClass().getName() + "]"));
        return "";
    }
}

