/*
 * Decompiled with CFR 0.152.
 */
package at.pollux.thymeleaf.shiro.processor.attribute;

import at.pollux.thymeleaf.shiro.dialect.ShiroFacade;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.attr.AbstractConditionalVisibilityAttrProcessor;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public class HasPermissionAttrProcessor
extends AbstractConditionalVisibilityAttrProcessor {
    private static final String ATTRIBUTE_NAME = "hasPermission";
    private static final int PRECEDENCE = 300;

    public static HasPermissionAttrProcessor create() {
        return new HasPermissionAttrProcessor();
    }

    protected HasPermissionAttrProcessor() {
        super(ATTRIBUTE_NAME);
    }

    public int getPrecedence() {
        return 300;
    }

    public boolean isVisible(Arguments arguments, Element element, String attributeName) {
        Validate.notNull((Object)element, (String)"element must not be null");
        Validate.notEmpty((String)attributeName, (String)"attributeName must not be empty");
        String permission = StringUtils.trim((Object)element.getAttributeValue(attributeName));
        Validate.notEmpty((String)permission, (String)("value of '" + attributeName + "' must not be empty"));
        return ShiroFacade.hasPermission(permission);
    }
}

