/*
 * Decompiled with CFR 0.152.
 */
package com.coder.zzq.toolkit.lifecycle;

import android.app.Activity;
import android.content.Intent;
import com.coder.zzq.toolkit.Utils;
import com.coder.zzq.toolkit.log.EasyLogger;
import java.util.LinkedList;

public final class ActivityStack {
    private static LinkedList<Activity> sActivitySet;

    private ActivityStack() {
    }

    public static void push(Activity activity) {
        if (activity != null) {
            EasyLogger.d("push activity : " + Utils.getActivityInfo(activity));
            ActivityStack.getActivitySet().add(activity);
        }
    }

    public static void pop(Activity activity) {
        if (ActivityStack.isEmpty()) {
            return;
        }
        int num = ActivityStack.count();
        for (int index = num - 1; index >= 0; --index) {
            if (ActivityStack.getActivitySet().get(index) != activity) continue;
            ActivityStack.getActivitySet().remove(index);
            EasyLogger.d("pop activity : " + Utils.getActivityInfo(activity));
            break;
        }
    }

    public static Activity getTop() {
        return ActivityStack.isEmpty() ? null : ActivityStack.getActivitySet().peekLast();
    }

    public static Activity below(Activity activity) {
        if (activity == null || ActivityStack.isEmpty()) {
            return null;
        }
        int num = ActivityStack.count();
        for (int index = num - 1; index >= 0; --index) {
            if (ActivityStack.getActivitySet().get(index) != activity) continue;
            return index == 0 ? null : ActivityStack.getActivitySet().get(index - 1);
        }
        return null;
    }

    public static Activity above(Activity activity) {
        if (activity == null || ActivityStack.isEmpty()) {
            return null;
        }
        int num = ActivityStack.count();
        for (int index = num - 1; index >= 0; --index) {
            if (ActivityStack.getActivitySet().get(index) != activity) continue;
            return index == num - 1 ? null : ActivityStack.getActivitySet().get(index + 1);
        }
        return null;
    }

    public static Activity get(Intent intent) {
        if (intent == null || ActivityStack.isEmpty()) {
            return null;
        }
        int num = ActivityStack.count();
        for (int index = num - 1; index >= 0; --index) {
            Activity activity = ActivityStack.getActivitySet().get(index);
            if (activity.getIntent() != intent) continue;
            return activity;
        }
        return null;
    }

    public static Activity get(Condition condition) {
        if (condition == null || ActivityStack.isEmpty()) {
            return null;
        }
        int num = ActivityStack.count();
        for (int index = num - 1; index >= 0; --index) {
            Activity activity = ActivityStack.getActivitySet().get(index);
            if (!condition.check(activity)) continue;
            return activity;
        }
        return null;
    }

    private static LinkedList<Activity> getActivitySet() {
        if (sActivitySet == null) {
            sActivitySet = new LinkedList();
        }
        return sActivitySet;
    }

    public static boolean isEmpty() {
        return sActivitySet == null || sActivitySet.isEmpty();
    }

    public static int count() {
        return sActivitySet == null ? 0 : sActivitySet.size();
    }

    public static boolean isInStack(Activity activity) {
        return !ActivityStack.isEmpty() && ActivityStack.getActivitySet().contains(activity);
    }

    public static interface Condition {
        public boolean check(Activity var1);
    }
}

