/*
 * Decompiled with CFR 0.152.
 */
package com.coder.zzq.toolkit.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.coder.zzq.toolkit.Utils;
import com.coder.zzq.toolkit.lifecycle.ActivityStack;
import com.coder.zzq.toolkit.log.EasyLogger;

public class ActivityCallback
implements Application.ActivityLifecycleCallbacks {
    private int mVisibleCounter = 0;
    private Activity mLastVisibleActivity;

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        EasyLogger.d("activity created:" + Utils.getActivityInfo(activity));
        ActivityStack.push(activity);
    }

    public void onActivityStarted(Activity activity) {
        EasyLogger.d("activity started:" + Utils.getActivityInfo(activity));
        if (this.mVisibleCounter == 0) {
            this.onAppForeground(this.mLastVisibleActivity == null);
        }
        ++this.mVisibleCounter;
        this.mLastVisibleActivity = activity;
    }

    public void onActivityResumed(Activity activity) {
        EasyLogger.d("activity resumed:" + Utils.getActivityInfo(activity));
    }

    public void onActivityPaused(Activity activity) {
        EasyLogger.d("activity paused:" + Utils.getActivityInfo(activity));
    }

    public void onActivityStopped(Activity activity) {
        EasyLogger.d("activity stopped:" + Utils.getActivityInfo(activity));
        --this.mVisibleCounter;
        if (this.mVisibleCounter == 0) {
            this.onAppBackground(ActivityStack.count() == 1 && activity.isFinishing());
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        EasyLogger.d("activity saveState:" + Utils.getActivityInfo(activity));
    }

    public void onActivityDestroyed(Activity activity) {
        EasyLogger.d("activity destroyed:" + Utils.getActivityInfo(activity));
        ActivityStack.pop(activity);
        if (activity == this.mLastVisibleActivity) {
            this.mLastVisibleActivity = null;
        }
        EasyLogger.d("the activity stack size:" + ActivityStack.count());
    }

    public void onAppForeground(boolean restartMainActivity) {
        EasyLogger.d("App foreground");
    }

    public void onAppBackground(boolean activityStackEmpty) {
        EasyLogger.d("App background");
    }
}

