/*
 * Decompiled with CFR 0.152.
 */
package com.coder.zzq.toolkit;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.coder.zzq.toolkit.Toolkit;
import com.coder.zzq.toolkit.lifecycle.ActivityStack;

public class Utils {
    public static int dpToPx(float dp) {
        return Math.round(TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Toolkit.getContext().getResources().getDisplayMetrics()));
    }

    @ColorInt
    public static int getColorFromRes(@ColorRes int colorRes) {
        return ContextCompat.getColor((Context)Toolkit.getContext(), (int)colorRes);
    }

    public static LayoutInflater getInflater() {
        return LayoutInflater.from((Context)Toolkit.getContext());
    }

    public static <T> T requireNonNull(T obj, String tip) {
        if (obj == null) {
            throw new NullPointerException(tip);
        }
        return obj;
    }

    public static boolean isEmpty(CharSequence c) {
        return TextUtils.isEmpty((CharSequence)c) || c.toString().trim().isEmpty();
    }

    public static int screenWidth() {
        return Toolkit.getContext().getResources().getDisplayMetrics().widthPixels;
    }

    public static int getStatusBarHeight() {
        int resourceId = Toolkit.getContext().getResources().getIdentifier("status_bar_height", "dimen", "android");
        int height = 0;
        try {
            height = Toolkit.getContext().getResources().getDimensionPixelSize(resourceId);
        }
        catch (Resources.NotFoundException e) {
            height = Utils.dpToPx(24.0f);
        }
        return height;
    }

    public static int getToolbarHeight() {
        int resourceId = Toolkit.getContext().getResources().getIdentifier("abc_action_bar_default_height_material", "dimen", "android");
        int height = 0;
        try {
            height = Toolkit.getContext().getResources().getDimensionPixelSize(resourceId);
        }
        catch (Resources.NotFoundException e) {
            height = Utils.dpToPx(56.0f);
        }
        return height;
    }

    public static boolean isActivityDestroyed(Activity activity) {
        return Build.VERSION.SDK_INT >= 17 ? activity.isDestroyed() : !ActivityStack.isInStack(activity);
    }

    public static void popKeyboardWhenDialogShow(Dialog dialog) {
        if (dialog != null) {
            dialog.getWindow().setSoftInputMode(5);
        }
    }

    public static void hideKeyboard(View view) {
        InputMethodManager imm;
        if (view != null && (imm = (InputMethodManager)Toolkit.getContext().getSystemService("input_method")) != null) {
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public static View inflate(@LayoutRes int layoutRes, ViewGroup viewGroup, boolean attach) {
        return LayoutInflater.from((Context)Toolkit.getContext()).inflate(layoutRes, viewGroup, attach);
    }

    public static View inflate(@LayoutRes int layoutRes, ViewGroup viewGroup) {
        return Utils.inflate(layoutRes, viewGroup, viewGroup != null);
    }

    public static Drawable getDrawableFromRes(int drawableRes) {
        return ContextCompat.getDrawable((Context)Toolkit.getContext(), (int)drawableRes);
    }

    public static void setBackgroundDrawable(View view, Drawable drawable) {
        if (view == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable);
        } else {
            view.setBackgroundDrawable(drawable);
        }
    }

    public static boolean isUpdateActivityUIPermitted(Activity activity) {
        return activity != null && !activity.isFinishing() && !Utils.isActivityDestroyed(activity);
    }

    public static boolean isUpdateFragmentUIPermitted(Fragment fragment) {
        return fragment != null && fragment.isVisible() && !fragment.isRemoving() && Utils.isUpdateActivityUIPermitted((Activity)fragment.getActivity());
    }

    public static boolean isCanShowDialogInFragment(Fragment fragment) {
        return Utils.isUpdateFragmentUIPermitted(fragment) && fragment.getUserVisibleHint();
    }

    public static String getStringFromRes(@StringRes int msg) {
        return Toolkit.getContext().getString(msg);
    }

    public static float pxToDp(int px) {
        float scale = Toolkit.getContext().getResources().getDisplayMetrics().density;
        return (float)px / scale;
    }

    public static boolean isNotificationPermitted() {
        return NotificationManagerCompat.from((Context)Toolkit.getContext()).areNotificationsEnabled();
    }

    public static int screenHeight() {
        return Toolkit.getContext().getResources().getDisplayMetrics().heightPixels;
    }

    public static String getActivityInfo(Activity activity) {
        return activity == null ? "the activity == null" : activity.getClass().getSimpleName() + "(" + activity.getClass().hashCode() + ")";
    }

    public static String getObjectDesc(Object object) {
        return object == null ? "(null)" : "(class:" + object.getClass().getSimpleName() + ";hashcode:" + object.hashCode() + ")";
    }

    public static int screenOrientation() {
        return Toolkit.getContext().getResources().getConfiguration().orientation;
    }

    public static boolean isScreenLandscape() {
        return Utils.screenOrientation() == 2;
    }

    public static boolean isScreenPortrait() {
        return Utils.screenOrientation() == 1;
    }

    public static boolean equals(Object one, Object another) {
        return one == another || one != null && one.equals(another);
    }
}

