/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.Labyrinth;
import com.github.sanctum.labyrinth.formatting.string.RandomID;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class HUID
implements Serializable {
    private String hUID;

    private HUID() {
    }

    private HUID(String hUID) {
        this.hUID = hUID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HUID)) {
            return false;
        }
        HUID huid = (HUID)o;
        return this.hUID.equals(huid.hUID);
    }

    public int hashCode() {
        return Objects.hash(this.hUID);
    }

    public String toString() {
        if (!this.hUID.contains("-")) {
            StringBuilder sb = new StringBuilder(this.hUID);
            sb.insert(4, '-');
            sb.insert(9, '-');
            return sb.toString().endsWith("-") ? sb.substring(0, sb.length() - 1) : sb.toString();
        }
        return this.hUID;
    }

    private void setId() {
        this.hUID = new RandomID(12).generate();
    }

    public static HUID randomID() {
        HUID result = new HUID();
        result.setId();
        return result;
    }

    public static HUID fromString(String wID) {
        if (!StringUtils.isAlphanumeric((String)wID) && !wID.contains("-")) {
            throw new TypeNotPresentException("HUID", new Throwable("[Labyrinth] - Unable to parse HUID, not alphanumeric."));
        }
        if (wID.replace("-", "").length() != 12) {
            try {
                return HUID.fromOldString(wID);
            }
            catch (NullPointerException e) {
                throw new TypeNotPresentException("HUID", new Throwable("[Labyrinth] - Unable to parse HUID, size greater/less than 12 char spec."));
            }
        }
        return new HUID(wID.replace("-", ""));
    }

    private static HUID fromOldString(String wID) {
        if (!wID.contains("-")) {
            throw new NullPointerException("[hempCore] - Unable to parse HUID");
        }
        if (wID.replace("-", "").length() != 6) {
            throw new NullPointerException("[hempCore] - Unable to parse HUID");
        }
        Labyrinth.getInstance().getLogger().warning("- Mocking full size NEW HUID, this is not guaranteed to work and could cause problems.");
        String add = new RandomID(6).generate();
        return new HUID(wID.replace("-", "") + add);
    }
}

