/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.builder;

import com.github.sanctum.labyrinth.gui.builder.BorderElement;
import com.github.sanctum.labyrinth.gui.builder.InventoryClick;
import com.github.sanctum.labyrinth.gui.builder.InventoryClose;
import com.github.sanctum.labyrinth.gui.builder.InventoryProcess;
import com.github.sanctum.labyrinth.gui.builder.InventoryRows;
import com.github.sanctum.labyrinth.gui.builder.PaginatedClick;
import com.github.sanctum.labyrinth.gui.builder.PaginatedClose;
import com.github.sanctum.labyrinth.gui.builder.PaginatedMenu;
import com.github.sanctum.labyrinth.gui.builder.ProcessElement;
import com.github.sanctum.labyrinth.gui.builder.SpareElement;
import com.github.sanctum.labyrinth.gui.builder.SyncMenuClickItemEvent;
import com.github.sanctum.labyrinth.gui.builder.SyncMenuItemPreProcessEvent;
import com.github.sanctum.labyrinth.gui.builder.SyncMenuSwitchPageEvent;
import com.github.sanctum.labyrinth.task.Schedule;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class PaginatedBuilder {
    protected Inventory inv;
    protected final Plugin plugin;
    protected int amountPer;
    protected int index;
    protected int page;
    protected int size;
    protected final UUID id;
    protected String title;
    protected String alreadyFirstPage;
    protected String alreadyLastPage;
    protected LinkedList<String> collection;
    protected ItemStack border;
    protected ItemStack fill;
    protected InventoryClose closeAction;
    protected InventoryProcess inventoryProcess;
    protected final Map<ItemStack, Integer> navLeft = new HashMap<ItemStack, Integer>();
    protected final Map<ItemStack, Integer> navRight = new HashMap<ItemStack, Integer>();
    protected final Map<ItemStack, Integer> navBack = new HashMap<ItemStack, Integer>();
    protected final Map<ItemStack, Integer> additional = new HashMap<ItemStack, Integer>();
    protected final PaginatedListener listener;
    protected final NamespacedKey key;
    protected final LinkedList<ItemStack> contents = new LinkedList();
    protected final Map<ItemStack, InventoryClick> actions = new HashMap<ItemStack, InventoryClick>();

    public PaginatedBuilder(Plugin plugin) {
        this.plugin = plugin;
        this.id = UUID.randomUUID();
        this.key = new NamespacedKey(plugin, "paginated_utility_manager");
        this.listener = new PaginatedListener(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.listener, plugin);
    }

    public PaginatedBuilder(Plugin plugin, String title) {
        this.title = title;
        this.plugin = plugin;
        this.id = UUID.randomUUID();
        this.key = new NamespacedKey(plugin, "paginated_utility_manager");
        this.listener = new PaginatedListener(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.listener, plugin);
    }

    public PaginatedBuilder setTitle(String title) {
        this.title = title.replace("{PAGE}", "" + this.page);
        return this;
    }

    public PaginatedBuilder collect(LinkedList<String> collection) {
        this.collection = collection;
        return this;
    }

    public PaginatedBuilder limit(int amountPer) {
        this.amountPer = amountPer;
        return this;
    }

    public PaginatedBuilder setSize(int size) {
        this.size = size;
        return this;
    }

    public PaginatedBuilder setSize(InventoryRows rows) {
        this.size = rows.getSlotCount();
        return this;
    }

    public PaginatedBuilder setAlreadyFirst(String context) {
        this.alreadyFirstPage = context.replace("{PAGE}", "" + this.page);
        return this;
    }

    public PaginatedBuilder setAlreadyLast(String context) {
        this.alreadyLastPage = context.replace("{PAGE}", "" + this.page);
        return this;
    }

    public PaginatedBuilder setCloseAction(InventoryClose inventoryClose) {
        this.closeAction = inventoryClose;
        return this;
    }

    public PaginatedBuilder setupProcess(InventoryProcess inventoryProcess) {
        this.inventoryProcess = inventoryProcess;
        return this;
    }

    public BorderElement addBorder() {
        return new BorderElement(this);
    }

    public SpareElement newItem() {
        return new SpareElement(this);
    }

    protected PaginatedBuilder adjust(int desiredPage) {
        LinkedList<String> members;
        this.page = desiredPage;
        if (this.border != null) {
            switch (this.size) {
                case 27: {
                    int f;
                    for (f = 0; f < 10; ++f) {
                        if (this.inv.getItem(f) != null) continue;
                        this.inv.setItem(f, this.border);
                    }
                    this.inv.setItem(17, this.border);
                    for (f = 18; f < 27; ++f) {
                        if (this.inv.getItem(f) != null) continue;
                        this.inv.setItem(f, this.border);
                    }
                    break;
                }
                case 36: {
                    int h;
                    for (h = 0; h < 10; ++h) {
                        if (this.inv.getItem(h) != null) continue;
                        this.inv.setItem(h, this.border);
                    }
                    this.inv.setItem(17, this.border);
                    this.inv.setItem(18, this.border);
                    this.inv.setItem(26, this.border);
                    for (h = 27; h < 36; ++h) {
                        if (this.inv.getItem(h) != null) continue;
                        this.inv.setItem(h, this.border);
                    }
                    break;
                }
                case 45: {
                    int o;
                    for (o = 0; o < 10; ++o) {
                        if (this.inv.getItem(o) != null) continue;
                        this.inv.setItem(o, this.border);
                    }
                    this.inv.setItem(17, this.border);
                    this.inv.setItem(18, this.border);
                    this.inv.setItem(26, this.border);
                    this.inv.setItem(27, this.border);
                    this.inv.setItem(35, this.border);
                    this.inv.setItem(36, this.border);
                    for (o = 36; o < 45; ++o) {
                        if (this.inv.getItem(o) != null) continue;
                        this.inv.setItem(o, this.border);
                    }
                    break;
                }
                case 54: {
                    int j;
                    for (j = 0; j < 10; ++j) {
                        if (this.inv.getItem(j) != null) continue;
                        this.inv.setItem(j, this.border);
                    }
                    this.inv.setItem(17, this.border);
                    this.inv.setItem(18, this.border);
                    this.inv.setItem(26, this.border);
                    this.inv.setItem(27, this.border);
                    this.inv.setItem(35, this.border);
                    this.inv.setItem(36, this.border);
                    for (j = 44; j < 54; ++j) {
                        if (this.inv.getItem(j) != null) continue;
                        this.inv.setItem(j, this.border);
                    }
                    break;
                }
            }
        }
        if (this.collection == null) {
            this.collection = new LinkedList();
        }
        if (!(members = this.collection).isEmpty()) {
            for (int i = 0; i < this.amountPer; ++i) {
                this.index = this.amountPer * this.page + i;
                if (this.index >= members.size()) break;
                if (members.get(this.index) == null) continue;
                boolean isNew = Arrays.stream(Material.values()).map(Enum::name).collect(Collectors.toList()).contains("PLAYER_HEAD");
                ItemStack item = isNew ? new ItemStack(Material.valueOf((String)"PLAYER_HEAD")) : new ItemStack(Material.valueOf((String)"SKULL_ITEM"));
                ItemStack left = this.navLeft.keySet().stream().findFirst().orElse(null);
                ItemStack right = this.navRight.keySet().stream().findFirst().orElse(null);
                ItemStack back = this.navBack.keySet().stream().findFirst().orElse(null);
                if (left != null && !this.inv.contains(left)) {
                    this.inv.setItem(this.navLeft.get(left).intValue(), left);
                    this.inv.setItem(this.navRight.get(right).intValue(), right);
                    this.inv.setItem(this.navBack.get(back).intValue(), back);
                }
                SyncMenuItemPreProcessEvent event = new SyncMenuItemPreProcessEvent(this, members.get(this.index), item);
                Bukkit.getPluginManager().callEvent((Event)event);
                Schedule.sync(() -> {
                    this.inv.addItem(new ItemStack[]{event.getItem()});
                    if (!this.contents.contains(event.getItem())) {
                        this.contents.add(event.getItem());
                    }
                    if (this.fill != null) {
                        Schedule.sync(() -> {
                            for (int l = 0; l < this.size; ++l) {
                                if (this.inv.getItem(l) != null) continue;
                                this.inv.setItem(l, this.fill);
                            }
                        }).debug().wait(1);
                    }
                }).debug().run();
            }
            if (!this.additional.isEmpty()) {
                for (Map.Entry<ItemStack, Integer> entry : this.additional.entrySet()) {
                    if (entry.getValue() == -1) {
                        this.inv.addItem(new ItemStack[]{entry.getKey()});
                        continue;
                    }
                    this.inv.setItem(entry.getValue().intValue(), entry.getKey());
                }
            }
        }
        return this;
    }

    protected PaginatedBuilder adjust() {
        LinkedList<String> members;
        if (this.border != null) {
            switch (this.size) {
                case 27: {
                    int f;
                    for (f = 0; f < 10; ++f) {
                        if (this.inv.getItem(f) != null) continue;
                        this.inv.setItem(f, this.border);
                    }
                    this.inv.setItem(17, this.border);
                    for (f = 18; f < 27; ++f) {
                        if (this.inv.getItem(f) != null) continue;
                        this.inv.setItem(f, this.border);
                    }
                    break;
                }
                case 36: {
                    int h;
                    for (h = 0; h < 10; ++h) {
                        if (this.inv.getItem(h) != null) continue;
                        this.inv.setItem(h, this.border);
                    }
                    this.inv.setItem(17, this.border);
                    this.inv.setItem(18, this.border);
                    this.inv.setItem(26, this.border);
                    for (h = 27; h < 36; ++h) {
                        if (this.inv.getItem(h) != null) continue;
                        this.inv.setItem(h, this.border);
                    }
                    break;
                }
                case 45: {
                    int o;
                    for (o = 0; o < 10; ++o) {
                        if (this.inv.getItem(o) != null) continue;
                        this.inv.setItem(o, this.border);
                    }
                    this.inv.setItem(17, this.border);
                    this.inv.setItem(18, this.border);
                    this.inv.setItem(26, this.border);
                    this.inv.setItem(27, this.border);
                    this.inv.setItem(35, this.border);
                    this.inv.setItem(36, this.border);
                    for (o = 36; o < 45; ++o) {
                        if (this.inv.getItem(o) != null) continue;
                        this.inv.setItem(o, this.border);
                    }
                    break;
                }
                case 54: {
                    int j;
                    for (j = 0; j < 10; ++j) {
                        if (this.inv.getItem(j) != null) continue;
                        this.inv.setItem(j, this.border);
                    }
                    this.inv.setItem(17, this.border);
                    this.inv.setItem(18, this.border);
                    this.inv.setItem(26, this.border);
                    this.inv.setItem(27, this.border);
                    this.inv.setItem(35, this.border);
                    this.inv.setItem(36, this.border);
                    for (j = 44; j < 54; ++j) {
                        if (this.inv.getItem(j) != null) continue;
                        this.inv.setItem(j, this.border);
                    }
                    break;
                }
            }
        }
        if (this.collection == null) {
            this.collection = new LinkedList();
        }
        if (!(members = this.collection).isEmpty()) {
            for (int i = 0; i < this.amountPer; ++i) {
                this.index = this.amountPer * this.page + i;
                if (this.index >= members.size()) break;
                if (members.get(this.index) == null) continue;
                boolean isNew = Arrays.stream(Material.values()).map(Enum::name).collect(Collectors.toList()).contains("PLAYER_HEAD");
                ItemStack item = isNew ? new ItemStack(Material.valueOf((String)"PLAYER_HEAD")) : new ItemStack(Material.valueOf((String)"SKULL_ITEM"));
                ItemStack left = this.navLeft.keySet().stream().findFirst().orElse(null);
                ItemStack right = this.navRight.keySet().stream().findFirst().orElse(null);
                ItemStack back = this.navBack.keySet().stream().findFirst().orElse(null);
                if (left != null && !this.inv.contains(left)) {
                    this.inv.setItem(this.navLeft.get(left).intValue(), left);
                    this.inv.setItem(this.navRight.get(right).intValue(), right);
                    this.inv.setItem(this.navBack.get(back).intValue(), back);
                }
                SyncMenuItemPreProcessEvent event = new SyncMenuItemPreProcessEvent(this, members.get(this.index), item);
                Bukkit.getPluginManager().callEvent((Event)event);
                Schedule.sync(() -> {
                    this.inv.addItem(new ItemStack[]{event.getItem()});
                    if (!this.contents.contains(event.getItem())) {
                        this.contents.add(event.getItem());
                    }
                    if (this.fill != null) {
                        Schedule.sync(() -> {
                            for (int l = 0; l < this.size; ++l) {
                                if (this.inv.getItem(l) != null) continue;
                                this.inv.setItem(l, this.fill);
                            }
                        }).debug().wait(1);
                    }
                }).debug().run();
            }
            if (!this.additional.isEmpty()) {
                for (Map.Entry<ItemStack, Integer> entry : this.additional.entrySet()) {
                    if (entry.getValue() == -1) {
                        this.inv.addItem(new ItemStack[]{entry.getKey()});
                        continue;
                    }
                    this.inv.setItem(entry.getValue().intValue(), entry.getKey());
                }
            }
        }
        return this;
    }

    public PaginatedBuilder setNavigationLeft(ItemStack item, int slot, InventoryClick click) {
        this.navLeft.putIfAbsent(item, slot);
        this.actions.putIfAbsent(item, click);
        return this;
    }

    public PaginatedBuilder setNavigationRight(ItemStack item, int slot, InventoryClick click) {
        this.navRight.putIfAbsent(item, slot);
        this.actions.putIfAbsent(item, click);
        return this;
    }

    public PaginatedBuilder setNavigationBack(ItemStack item, int slot, InventoryClick click) {
        this.navBack.putIfAbsent(item, slot);
        this.actions.putIfAbsent(item, click);
        return this;
    }

    public PaginatedMenu build() {
        return new PaginatedMenu(this);
    }

    public UUID getId() {
        return this.id;
    }

    public Inventory getInventory() {
        return this.inv;
    }

    public PaginatedListener getListener() {
        return this.listener;
    }

    public int getAmountPerPage() {
        return this.amountPer;
    }

    public int getMaxPages() {
        return this.collection.size() / (this.amountPer - 1) < 0 ? this.collection.size() / this.amountPer : this.collection.size() / this.amountPer - 1;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public LinkedList<String> getCollection() {
        return this.collection;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    private static class PaginatedListener
    implements Listener {
        private final PaginatedBuilder builder;

        protected PaginatedListener(PaginatedBuilder builder) {
            this.builder = builder;
        }

        @EventHandler(priority=EventPriority.NORMAL)
        public void onProcess(SyncMenuItemPreProcessEvent e) {
            this.builder.inventoryProcess.processEvent(new ProcessElement(e));
        }

        @EventHandler(priority=EventPriority.NORMAL)
        public void onClose(InventoryCloseEvent e) {
            if (!(e.getPlayer() instanceof Player)) {
                return;
            }
            if (e.getView().getTopInventory().getSize() < this.builder.size) {
                return;
            }
            if (this.builder.getInventory() == e.getInventory()) {
                if (this.builder.closeAction != null) {
                    this.builder.closeAction.closeEvent(new PaginatedClose(this.builder, (Player)e.getPlayer(), e.getView()));
                }
                this.builder.page = 0;
                this.builder.index = 0;
            }
        }

        @EventHandler(priority=EventPriority.NORMAL)
        public void onClick(InventoryClickEvent e) {
            if (!(e.getWhoClicked() instanceof Player)) {
                return;
            }
            if (e.getView().getTopInventory().getSize() < this.builder.size) {
                return;
            }
            if (e.getHotbarButton() != -1) {
                e.setCancelled(true);
                return;
            }
            if (e.getClickedInventory() == e.getInventory()) {
                Player p = (Player)e.getWhoClicked();
                if (e.getCurrentItem() != null) {
                    SyncMenuSwitchPageEvent event1;
                    ItemStack item = e.getCurrentItem();
                    SyncMenuClickItemEvent event = new SyncMenuClickItemEvent(this.builder, p, e.getView(), item);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        e.setCancelled(true);
                        return;
                    }
                    if (this.builder.contents.contains(item)) {
                        this.builder.actions.get(item).clickEvent(new PaginatedClick(this.builder, p, e.getView(), item));
                        e.setCancelled(true);
                    }
                    if (this.builder.navBack.keySet().stream().anyMatch(i -> i.isSimilar(item))) {
                        this.builder.actions.get(item).clickEvent(new PaginatedClick(this.builder, p, e.getView(), item));
                        e.setCancelled(true);
                    }
                    if (this.builder.navLeft.keySet().stream().anyMatch(i -> i.isSimilar(item))) {
                        if (this.builder.page == 0) {
                            p.sendMessage(this.builder.alreadyFirstPage);
                        } else {
                            event1 = new SyncMenuSwitchPageEvent(this.builder, p, e.getView(), item, this.builder.page);
                            Bukkit.getPluginManager().callEvent((Event)event1);
                            if (!event1.isCancelled()) {
                                --this.builder.page;
                            }
                            this.builder.actions.get(item).clickEvent(new PaginatedClick(this.builder, p, e.getView(), item));
                        }
                        e.setCancelled(true);
                    }
                    if (this.builder.navRight.keySet().stream().anyMatch(i -> i.isSimilar(item))) {
                        if (this.builder.index + 1 < this.builder.collection.size()) {
                            event1 = new SyncMenuSwitchPageEvent(this.builder, p, e.getView(), item, this.builder.page);
                            Bukkit.getPluginManager().callEvent((Event)event1);
                            if (!event1.isCancelled()) {
                                ++this.builder.page;
                                this.builder.actions.get(item).clickEvent(new PaginatedClick(this.builder, p, e.getView(), item));
                            }
                        } else {
                            p.sendMessage(this.builder.alreadyLastPage);
                        }
                        e.setCancelled(true);
                    }
                    if (e.getCurrentItem().equals((Object)this.builder.border) || item.equals((Object)this.builder.fill)) {
                        e.setCancelled(true);
                    }
                }
            }
        }
    }
}

