/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.labyrinth.Labyrinth;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook {
    private static Economy econ = null;
    private final Labyrinth instance;

    public VaultHook(Labyrinth instance) {
        this.instance = instance;
        if (!this.economyFound()) {
            instance.getLogger().warning("- No vault economy provider found.");
            instance.getLogger().warning("- Vault economy implementations from Labyrinth will not work.");
        }
    }

    private boolean economyFound() {
        if (this.instance.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.instance.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        this.instance.getLogger().info("- Vault economy provider found. Now using: " + ((Economy)rsp.getProvider()).getName());
        return true;
    }

    public static Economy getEconomy() {
        return econ;
    }
}

