/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.labyrinth.Labyrinth;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Config {
    private final String n;
    private final String d;
    private FileConfiguration fc;
    private File file;
    private final JavaPlugin plugin = JavaPlugin.getProvidingPlugin(Config.class);
    private static final List<Config> configs = new ArrayList<Config>();

    public Config(String n, String d) {
        this.n = n;
        this.d = d;
        configs.add(this);
    }

    public static void copy(InputStream in, File file) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return this.n == null ? "" : this.n;
    }

    public String getDirectory() {
        return this.d == null ? "" : this.d;
    }

    public static Config get(String n, String d) {
        for (Config c : configs) {
            if (!c.getName().equals(n) || c.getDirectory() == null || !c.getDirectory().equals(d)) continue;
            return c;
        }
        return new Config(n, d);
    }

    public void flush() {
        configs.removeIf(c -> c.getName().equals(this.getName()));
    }

    public boolean delete() {
        configs.removeIf(c -> c.getName().equals(this.getName()));
        return this.getFile().delete();
    }

    public boolean exists() {
        if (this.fc == null || this.file == null) {
            File temp = new File(this.getDataFolder(), this.getName() + ".yml");
            if (!temp.exists()) {
                return false;
            }
            this.file = temp;
        }
        return true;
    }

    public File getFile() {
        if (this.file == null) {
            this.file = new File(this.getDataFolder(), this.getName() + ".yml");
            if (!this.file.exists()) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.file;
    }

    public FileConfiguration getConfig() {
        if (this.fc == null) {
            this.fc = YamlConfiguration.loadConfiguration((File)this.getFile());
        }
        return this.fc;
    }

    public File getDataFolder() {
        File dir = new File(Config.class.getProtectionDomain().getCodeSource().getLocation().getPath().replaceAll("%20", " "));
        File d = this.d != null ? new File(dir.getParentFile().getPath(), Labyrinth.getInstance().getName() + "/" + this.d + "/") : new File(dir.getParentFile().getPath(), Labyrinth.getInstance().getName());
        if (!d.exists()) {
            d.mkdirs();
        }
        return d;
    }

    public void reload() {
        if (this.file == null) {
            this.file = new File(this.getDataFolder(), this.getName() + ".yml");
            if (!this.file.exists()) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.fc = YamlConfiguration.loadConfiguration((File)this.file);
            File defConfigStream = new File(this.plugin.getDataFolder(), this.getName() + ".yml");
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((File)defConfigStream);
            this.fc.setDefaults((Configuration)defConfig);
            configs.removeIf(c -> c.getName().equals(this.n));
        }
    }

    public void saveConfig() {
        try {
            this.getConfig().save(this.getFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

