/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.economy.construct.entity.types;

import com.github.sanctum.economy.construct.entity.EconomyEntity;
import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpcEntity
implements EconomyEntity {
    protected final NamespacedKey namespacedKey;
    protected final String internalName;
    protected String friendlyName;
    protected final String pluginName;

    public NpcEntity(@NotNull Plugin plugin, @NotNull String name) {
        this.internalName = name;
        this.friendlyName = name;
        this.namespacedKey = new NamespacedKey(plugin, name);
        this.pluginName = plugin.getName();
    }

    @Nullable
    public String getPluginName() {
        return this.pluginName;
    }

    public void setFriendlyName(Plugin plugin, String friendlyName) {
        NamespacedKey newKey = new NamespacedKey(plugin, this.internalName);
        if (this.namespacedKey.equals((Object)newKey)) {
            this.friendlyName = friendlyName;
        }
    }

    @Override
    @NotNull
    public String friendlyName() {
        return this.friendlyName;
    }

    @Override
    @NotNull
    public String id() {
        return "npc=" + this.namespacedKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NpcEntity npcEntity = (NpcEntity)o;
        return this.namespacedKey.equals((Object)npcEntity.namespacedKey);
    }

    public int hashCode() {
        return Objects.hash(this.namespacedKey, this.internalName);
    }
}

