/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.economy.construct.entity;

import com.github.sanctum.economy.construct.entity.EconomyEntity;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public abstract class PlayerEconomyEntityBase
implements EconomyEntity {
    protected final OfflinePlayer offlinePlayer;
    protected final UUID uid;

    protected PlayerEconomyEntityBase(@NotNull OfflinePlayer offlinePlayer) {
        this.offlinePlayer = Objects.requireNonNull(offlinePlayer);
        this.uid = offlinePlayer.getUniqueId();
    }

    @Override
    @NotNull
    public String friendlyName() {
        return this.offlinePlayer.getName();
    }

    public OfflinePlayer getPlayer() {
        return this.offlinePlayer;
    }

    public UUID getUniqueId() {
        return this.uid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.id().equals(((PlayerEconomyEntityBase)o).id());
    }

    public int hashCode() {
        return Objects.hash(this.id());
    }
}

