/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.economy.construct.account;

import com.github.sanctum.economy.construct.EconomyAction;
import com.github.sanctum.economy.construct.account.Balance;
import com.github.sanctum.economy.construct.account.permissive.AccountType;
import com.github.sanctum.economy.construct.entity.EconomyEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;

public abstract class Account
extends Balance {
    private final AccountType accountType;
    private final List<String> members;

    public Account(AccountType accountType, EconomyEntity holder, EconomyEntity ... members) {
        super(holder);
        this.accountType = accountType;
        this.members = Arrays.stream(members).map(EconomyEntity::id).collect(Collectors.toList());
    }

    public AccountType getType() {
        return this.accountType;
    }

    public String getId() {
        return "your-id-here";
    }

    public List<String> getMembers() {
        return this.members;
    }

    @Deprecated
    public abstract EconomyAction isOwner(String var1);

    @Deprecated
    public abstract EconomyAction isOwner(String var1, String var2);

    public abstract EconomyAction isOwner(OfflinePlayer var1);

    public abstract EconomyAction isOwner(OfflinePlayer var1, String var2);

    public abstract EconomyAction isOwner(UUID var1);

    public abstract EconomyAction isOwner(UUID var1, String var2);

    @Deprecated
    public abstract EconomyAction isJointOwner(String var1);

    @Deprecated
    public abstract EconomyAction isJointOwner(String var1, String var2);

    public abstract EconomyAction isJointOwner(OfflinePlayer var1);

    public abstract EconomyAction isJointOwner(OfflinePlayer var1, String var2);

    public abstract EconomyAction isJointOwner(UUID var1);

    public abstract EconomyAction isJointOwner(UUID var1, String var2);

    @Deprecated
    public abstract EconomyAction isMember(String var1);

    @Deprecated
    public abstract EconomyAction isMember(String var1, String var2);

    public abstract EconomyAction isMember(OfflinePlayer var1);

    public abstract EconomyAction isMember(OfflinePlayer var1, String var2);

    public abstract EconomyAction isMember(UUID var1);

    public abstract EconomyAction isMember(UUID var1, String var2);

    @Deprecated
    public abstract EconomyAction addMember(String var1);

    @Deprecated
    public abstract EconomyAction addMember(String var1, String var2);

    public abstract EconomyAction addMember(OfflinePlayer var1);

    public abstract EconomyAction addMember(OfflinePlayer var1, String var2);

    public abstract EconomyAction addMember(UUID var1);

    public abstract EconomyAction addMember(UUID var1, String var2);

    @Deprecated
    public abstract EconomyAction removeMember(String var1);

    @Deprecated
    public abstract EconomyAction removeMember(String var1, String var2);

    public abstract EconomyAction removeMember(OfflinePlayer var1);

    public abstract EconomyAction removeMember(OfflinePlayer var1, String var2);

    public abstract EconomyAction removeMember(UUID var1);

    public abstract EconomyAction removeMember(UUID var1, String var2);

    public String toString() {
        return "Account{accountType=" + (Object)((Object)this.accountType) + ", members=" + this.members + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account account = (Account)o;
        return this.accountType == account.accountType && Objects.equals(this.getMembers(), account.getMembers());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountType, this.getMembers()});
    }
}

