/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.economy.construct;

import com.github.sanctum.economy.construct.entity.EconomyEntity;
import com.github.sanctum.economy.construct.events.AsyncEconomyInfoEvent;
import com.github.sanctum.economy.construct.events.AsyncTransactionEvent;
import java.math.BigDecimal;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Nullable;

public class EconomyAction {
    private static final PluginManager PM = Bukkit.getPluginManager();
    private final BigDecimal amount;
    private final boolean success;
    private boolean logged = false;
    private final String info;
    private final EconomyEntity holder;

    public EconomyAction(BigDecimal amount, EconomyEntity holder, boolean success, String transactionInfo) {
        this.amount = amount;
        this.success = success;
        this.info = transactionInfo != null ? transactionInfo : "";
        this.holder = holder;
    }

    public EconomyAction(EconomyEntity holder, boolean success, String transactionInfo) {
        this(null, holder, success, transactionInfo);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public EconomyEntity getActiveHolder() {
        return this.holder;
    }

    @Nullable
    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getInfo() {
        return this.info;
    }

    public EconomyAction log() {
        if (!this.logged) {
            final EconomyAction economyAction = this;
            new BukkitRunnable(){

                public void run() {
                    PM.callEvent(EconomyAction.this.amount != null ? new AsyncTransactionEvent(economyAction) : new AsyncEconomyInfoEvent(economyAction));
                }
            }.runTaskAsynchronously((Plugin)JavaPlugin.getProvidingPlugin(EconomyAction.class));
            this.logged = true;
        }
        return this;
    }
}

