/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.economy;

import com.github.sanctum.economy.construct.EconomyAction;
import com.github.sanctum.economy.construct.account.Wallet;
import com.github.sanctum.economy.construct.account.permissive.AccountType;
import com.github.sanctum.economy.construct.events.AsyncEconomyInfoEvent;
import com.github.sanctum.economy.construct.events.AsyncTransactionEvent;
import com.github.sanctum.economy.construct.implement.AdvancedEconomy;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class Enterprise
extends JavaPlugin {
    private static Enterprise instance;

    public void onEnable() {
        instance = this;
        this.registerCommand(new EnterpriseCommand());
        this.getServer().getPluginManager().registerEvents((Listener)new LoggingListener(), (Plugin)this);
    }

    public void onDisable() {
    }

    private void registerCommand(Command command) {
        try {
            Field commandMapField = this.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(this.getServer());
            commandMap.register(this.getName(), command);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private class EnterpriseCommand
    extends Command {
        public EnterpriseCommand() {
            super("enterprise");
        }

        private void sendMessage(CommandSender player, String message) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&f[&2" + instance.getName() + "&f] " + message)));
        }

        public boolean execute(CommandSender sender, String commandLabel, String[] args) {
            Collection economies = Enterprise.this.getServer().getServicesManager().getRegistrations(AdvancedEconomy.class);
            if (sender instanceof Player && !sender.hasPermission("enterprise.staff")) {
                this.sendMessage(sender, "&c&oThis is a staff-only command.");
                return true;
            }
            if (args.length == 0) {
                String ecos = economies.stream().map(RegisteredServiceProvider::getProvider).map(AdvancedEconomy::getPlugin).map(Plugin::getName).collect(Collectors.toList()).toString();
                this.sendMessage(sender, "Registered Advanced Economies: " + ecos);
                return true;
            }
            if (args.length == 3) {
                if (args[0].equalsIgnoreCase("convert")) {
                    if (economies == null || economies.size() < 2) {
                        this.sendMessage(sender, "You must have at least 2 Enterprise-compatible economies loaded to convert.");
                        return true;
                    }
                    AdvancedEconomy econ1 = economies.stream().filter(e -> ((AdvancedEconomy)e.getProvider()).getPlugin().getName().equalsIgnoreCase(args[1])).findFirst().map(RegisteredServiceProvider::getProvider).orElse(null);
                    if (econ1 == null) {
                        String ecos = economies.stream().map(RegisteredServiceProvider::getProvider).map(AdvancedEconomy::getPlugin).map(Plugin::getName).collect(Collectors.toList()).toString();
                        this.sendMessage(sender, "Economy " + args[1] + " was not found. Ensure you have it loaded properly.");
                        this.sendMessage(sender, "Valid economies are: " + ecos);
                        return true;
                    }
                    AdvancedEconomy econ2 = economies.stream().filter(e -> ((AdvancedEconomy)e.getProvider()).getPlugin().getName().equalsIgnoreCase(args[2])).findFirst().map(RegisteredServiceProvider::getProvider).orElse(null);
                    if (econ2 == null) {
                        String ecos = economies.stream().map(RegisteredServiceProvider::getProvider).map(AdvancedEconomy::getPlugin).map(Plugin::getName).collect(Collectors.toList()).toString();
                        this.sendMessage(sender, "Economy " + args[2] + " was not found. Ensure you have it loaded properly.");
                        this.sendMessage(sender, "Valid economies are: " + ecos);
                        return true;
                    }
                    this.sendMessage(sender, "&e&oDepending on the amount of registrations this may take a while.");
                    long time = System.currentTimeMillis();
                    for (OfflinePlayer op : Bukkit.getServer().getOfflinePlayers()) {
                        if (!econ1.hasWalletAccount(op) || econ2.hasWalletAccount(op)) continue;
                        econ2.createAccount(AccountType.ENTITY_ACCOUNT, op);
                        Wallet wallet1 = econ1.getWallet(op);
                        Wallet wallet2 = econ2.getWallet(op);
                        BigDecimal diff = Objects.requireNonNull(wallet1.getBalance()).subtract(wallet2.getBalance());
                        if (diff.compareTo(BigDecimal.ZERO) > 0) {
                            wallet2.deposit(diff);
                            continue;
                        }
                        if (diff.compareTo(BigDecimal.ZERO) >= 0) continue;
                        wallet2.withdraw(diff.negate());
                    }
                    long complete = (System.currentTimeMillis() - time) / 1000L;
                    int second = Integer.parseInt(String.valueOf(complete));
                    this.sendMessage(sender, "&aConversion completed in " + second + " seconds.");
                    return true;
                }
                return true;
            }
            return false;
        }
    }

    private class LoggingListener
    implements Listener {
        private LoggingListener() {
        }

        @EventHandler
        public void onInfoEvent(AsyncEconomyInfoEvent e) {
            EconomyAction economyAction = e.getEconomyAction();
            Enterprise.this.getLogger().info(String.format("EconomyEntity: %s [%s] Info: %s", economyAction.getActiveHolder().friendlyName(), economyAction.isSuccess(), economyAction.getInfo()));
        }

        @EventHandler
        public void onInfoEvent(AsyncTransactionEvent e) {
            EconomyAction economyAction = e.getEconomyAction();
            Enterprise.this.getLogger().info(String.format("EconomyEntity: %s [%s] Amount: %s Info: %s", economyAction.getActiveHolder().friendlyName(), economyAction.isSuccess(), economyAction.getAmount(), economyAction.getInfo()));
        }
    }
}

