/*
 * Decompiled with CFR 0.152.
 */
package com.github.testpress.mikephil.charting.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import com.github.testpress.mikephil.charting.utils.FSize;
import com.github.testpress.mikephil.charting.utils.MPPointF;
import java.util.List;

public abstract class Utils {
    private static DisplayMetrics mMetrics;
    private static int mMinimumFlingVelocity;
    private static int mMaximumFlingVelocity;
    public static final double DEG2RAD = Math.PI / 180;
    public static final float FDEG2RAD = (float)Math.PI / 180;
    private static Rect mCalcTextHeightRect;
    private static Rect mCalcTextSizeRect;
    private static final int[] POW_10;
    private static Rect mDrawTextRectBuffer;
    private static Paint.FontMetrics mFontMetricsBuffer;

    public static void init(Context context) {
        if (context == null) {
            mMinimumFlingVelocity = ViewConfiguration.getMinimumFlingVelocity();
            mMaximumFlingVelocity = ViewConfiguration.getMaximumFlingVelocity();
            Log.e((String)"MPChartLib-Utils", (String)"Utils.init(...) PROVIDED CONTEXT OBJECT IS NULL");
        } else {
            ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
            mMinimumFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
            mMaximumFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
            Resources res = context.getResources();
            mMetrics = res.getDisplayMetrics();
        }
    }

    @Deprecated
    public static void init(Resources res) {
        mMetrics = res.getDisplayMetrics();
        mMinimumFlingVelocity = ViewConfiguration.getMinimumFlingVelocity();
        mMaximumFlingVelocity = ViewConfiguration.getMaximumFlingVelocity();
    }

    public static float convertDpToPixel(float dp) {
        if (mMetrics == null) {
            Log.e((String)"MPChartLib-Utils", (String)"Utils NOT INITIALIZED. You need to call Utils.init(...) at least once before calling Utils.convertDpToPixel(...). Otherwise conversion does not take place.");
            return dp;
        }
        DisplayMetrics metrics = mMetrics;
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    public static float convertPixelsToDp(float px) {
        if (mMetrics == null) {
            Log.e((String)"MPChartLib-Utils", (String)"Utils NOT INITIALIZED. You need to call Utils.init(...) at least once before calling Utils.convertPixelsToDp(...). Otherwise conversion does not take place.");
            return px;
        }
        DisplayMetrics metrics = mMetrics;
        float dp = px / ((float)metrics.densityDpi / 160.0f);
        return dp;
    }

    public static int calcTextWidth(Paint paint, String demoText) {
        return (int)paint.measureText(demoText);
    }

    public static int calcTextHeight(Paint paint, String demoText) {
        Rect r = mCalcTextHeightRect;
        r.set(0, 0, 0, 0);
        paint.getTextBounds(demoText, 0, demoText.length(), r);
        return r.height();
    }

    public static float getLineHeight(Paint paint) {
        Paint.FontMetrics metrics = new Paint.FontMetrics();
        return Utils.getLineHeight(paint, metrics);
    }

    public static float getLineHeight(Paint paint, Paint.FontMetrics fontMetrics) {
        paint.getFontMetrics(fontMetrics);
        return fontMetrics.descent - fontMetrics.ascent;
    }

    public static float getLineSpacing(Paint paint) {
        Paint.FontMetrics metrics = new Paint.FontMetrics();
        return Utils.getLineSpacing(paint, metrics);
    }

    public static float getLineSpacing(Paint paint, Paint.FontMetrics fontMetrics) {
        paint.getFontMetrics(fontMetrics);
        return fontMetrics.ascent - fontMetrics.top + fontMetrics.bottom;
    }

    public static FSize calcTextSize(Paint paint, String demoText) {
        FSize result = FSize.getInstance(0.0f, 0.0f);
        Utils.calcTextSize(paint, demoText, result);
        return result;
    }

    public static void calcTextSize(Paint paint, String demoText, FSize outputFSize) {
        Rect r = mCalcTextSizeRect;
        r.set(0, 0, 0, 0);
        paint.getTextBounds(demoText, 0, demoText.length(), r);
        outputFSize.width = r.width();
        outputFSize.height = r.height();
    }

    public static String formatNumber(float number, int digitCount, boolean separateThousands) {
        return Utils.formatNumber(number, digitCount, separateThousands, '.');
    }

    public static String formatNumber(float number, int digitCount, boolean separateThousands, char separateChar) {
        char[] out = new char[35];
        boolean neg = false;
        if (number == 0.0f) {
            return "0";
        }
        boolean zero = false;
        if (number < 1.0f && number > -1.0f) {
            zero = true;
        }
        if (number < 0.0f) {
            neg = true;
            number = -number;
        }
        if (digitCount > POW_10.length) {
            digitCount = POW_10.length - 1;
        }
        long lval = Math.round(number *= (float)POW_10[digitCount]);
        int ind = out.length - 1;
        int charCount = 0;
        boolean decimalPointAdded = false;
        while (lval != 0L || charCount < digitCount + 1) {
            int digit = (int)(lval % 10L);
            lval /= 10L;
            out[ind--] = (char)(digit + 48);
            if (++charCount == digitCount) {
                out[ind--] = 44;
                ++charCount;
                decimalPointAdded = true;
                continue;
            }
            if (!separateThousands || lval == 0L || charCount <= digitCount) continue;
            if (decimalPointAdded) {
                if ((charCount - digitCount) % 4 != 0) continue;
                out[ind--] = separateChar;
                ++charCount;
                continue;
            }
            if ((charCount - digitCount) % 4 != 3) continue;
            out[ind--] = separateChar;
            ++charCount;
        }
        if (zero) {
            out[ind--] = 48;
            ++charCount;
        }
        if (neg) {
            out[ind--] = 45;
            ++charCount;
        }
        int start = out.length - charCount;
        return String.valueOf(out, start, out.length - start);
    }

    public static float roundToNextSignificant(double number) {
        float d = (float)Math.ceil((float)Math.log10(number < 0.0 ? -number : number));
        int pw = 1 - (int)d;
        float magnitude = (float)Math.pow(10.0, pw);
        long shifted = Math.round(number * (double)magnitude);
        return (float)shifted / magnitude;
    }

    public static int getDecimals(float number) {
        float i = Utils.roundToNextSignificant(number);
        return (int)Math.ceil(-Math.log10(i)) + 2;
    }

    public static int[] convertIntegers(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        Utils.copyIntegers(integers, ret);
        return ret;
    }

    public static void copyIntegers(List<Integer> from, int[] to) {
        int count = to.length < from.size() ? to.length : from.size();
        for (int i = 0; i < count; ++i) {
            to[i] = from.get(i);
        }
    }

    public static String[] convertStrings(List<String> strings) {
        String[] ret = new String[strings.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = strings.get(i);
        }
        return ret;
    }

    public static void copyStrings(List<String> from, String[] to) {
        int count = to.length < from.size() ? to.length : from.size();
        for (int i = 0; i < count; ++i) {
            to[i] = from.get(i);
        }
    }

    public static double nextUp(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return d;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d += 0.0) + (d >= 0.0 ? 1L : -1L));
    }

    public static MPPointF getPosition(MPPointF center, float dist, float angle) {
        MPPointF p = MPPointF.getInstance(0.0f, 0.0f);
        Utils.getPosition(center, dist, angle, p);
        return p;
    }

    public static void getPosition(MPPointF center, float dist, float angle, MPPointF outputPoint) {
        outputPoint.x = (float)((double)center.x + (double)dist * Math.cos(Math.toRadians(angle)));
        outputPoint.y = (float)((double)center.y + (double)dist * Math.sin(Math.toRadians(angle)));
    }

    public static void velocityTrackerPointerUpCleanUpIfNecessary(MotionEvent ev, VelocityTracker tracker) {
        tracker.computeCurrentVelocity(1000, (float)mMaximumFlingVelocity);
        int upIndex = ev.getActionIndex();
        int id1 = ev.getPointerId(upIndex);
        float x1 = tracker.getXVelocity(id1);
        float y1 = tracker.getYVelocity(id1);
        int count = ev.getPointerCount();
        for (int i = 0; i < count; ++i) {
            float y;
            int id2;
            float x;
            float dot;
            if (i == upIndex || !((dot = (x = x1 * tracker.getXVelocity(id2 = ev.getPointerId(i))) + (y = y1 * tracker.getYVelocity(id2))) < 0.0f)) continue;
            tracker.clear();
            break;
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void postInvalidateOnAnimation(View view) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.postInvalidateOnAnimation();
        } else {
            view.postInvalidateDelayed(10L);
        }
    }

    public static int getMinimumFlingVelocity() {
        return mMinimumFlingVelocity;
    }

    public static int getMaximumFlingVelocity() {
        return mMaximumFlingVelocity;
    }

    public static float getNormalizedAngle(float angle) {
        while (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle % 360.0f;
    }

    public static void drawXAxisValue(Canvas c, String text, float x, float y, Paint paint, MPPointF anchor, float angleDegrees) {
        float drawOffsetX = 0.0f;
        float drawOffsetY = 0.0f;
        float lineHeight = paint.getFontMetrics(mFontMetricsBuffer);
        paint.getTextBounds(text, 0, text.length(), mDrawTextRectBuffer);
        drawOffsetX -= (float)Utils.mDrawTextRectBuffer.left;
        drawOffsetY += -Utils.mFontMetricsBuffer.ascent;
        Paint.Align originalTextAlign = paint.getTextAlign();
        paint.setTextAlign(Paint.Align.LEFT);
        if (angleDegrees != 0.0f) {
            drawOffsetX -= (float)mDrawTextRectBuffer.width() * 0.5f;
            drawOffsetY -= lineHeight * 0.5f;
            float translateX = x;
            float translateY = y;
            if (anchor.x != 0.5f || anchor.y != 0.5f) {
                FSize rotatedSize = Utils.getSizeOfRotatedRectangleByDegrees(mDrawTextRectBuffer.width(), lineHeight, angleDegrees);
                translateX -= rotatedSize.width * (anchor.x - 0.5f);
                translateY -= rotatedSize.height * (anchor.y - 0.5f);
                FSize.recycleInstance(rotatedSize);
            }
            c.save();
            c.translate(translateX, translateY);
            c.rotate(angleDegrees);
            c.drawText(text, drawOffsetX, drawOffsetY, paint);
            c.restore();
        } else {
            if (anchor.x != 0.0f || anchor.y != 0.0f) {
                drawOffsetX -= (float)mDrawTextRectBuffer.width() * anchor.x;
                drawOffsetY -= lineHeight * anchor.y;
            }
            c.drawText(text, drawOffsetX += x, drawOffsetY += y, paint);
        }
        paint.setTextAlign(originalTextAlign);
    }

    public static void drawMultilineText(Canvas c, StaticLayout textLayout, float x, float y, TextPaint paint, MPPointF anchor, float angleDegrees) {
        float drawOffsetX = 0.0f;
        float drawOffsetY = 0.0f;
        float lineHeight = paint.getFontMetrics(mFontMetricsBuffer);
        float drawWidth = textLayout.getWidth();
        float drawHeight = (float)textLayout.getLineCount() * lineHeight;
        drawOffsetX -= (float)Utils.mDrawTextRectBuffer.left;
        drawOffsetY += drawHeight;
        Paint.Align originalTextAlign = paint.getTextAlign();
        paint.setTextAlign(Paint.Align.LEFT);
        if (angleDegrees != 0.0f) {
            drawOffsetX -= drawWidth * 0.5f;
            drawOffsetY -= drawHeight * 0.5f;
            float translateX = x;
            float translateY = y;
            if (anchor.x != 0.5f || anchor.y != 0.5f) {
                FSize rotatedSize = Utils.getSizeOfRotatedRectangleByDegrees(drawWidth, drawHeight, angleDegrees);
                translateX -= rotatedSize.width * (anchor.x - 0.5f);
                translateY -= rotatedSize.height * (anchor.y - 0.5f);
                FSize.recycleInstance(rotatedSize);
            }
            c.save();
            c.translate(translateX, translateY);
            c.rotate(angleDegrees);
            c.translate(drawOffsetX, drawOffsetY);
            textLayout.draw(c);
            c.restore();
        } else {
            if (anchor.x != 0.0f || anchor.y != 0.0f) {
                drawOffsetX -= drawWidth * anchor.x;
                drawOffsetY -= drawHeight * anchor.y;
            }
            c.save();
            c.translate(drawOffsetX += x, drawOffsetY += y);
            textLayout.draw(c);
            c.restore();
        }
        paint.setTextAlign(originalTextAlign);
    }

    public static void drawMultilineText(Canvas c, String text, float x, float y, TextPaint paint, FSize constrainedToSize, MPPointF anchor, float angleDegrees) {
        StaticLayout textLayout = new StaticLayout((CharSequence)text, 0, text.length(), paint, (int)Math.max(Math.ceil(constrainedToSize.width), 1.0), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        Utils.drawMultilineText(c, textLayout, x, y, paint, anchor, angleDegrees);
    }

    public static FSize getSizeOfRotatedRectangleByDegrees(FSize rectangleSize, float degrees) {
        float radians = degrees * ((float)Math.PI / 180);
        return Utils.getSizeOfRotatedRectangleByRadians(rectangleSize.width, rectangleSize.height, radians);
    }

    public static FSize getSizeOfRotatedRectangleByRadians(FSize rectangleSize, float radians) {
        return Utils.getSizeOfRotatedRectangleByRadians(rectangleSize.width, rectangleSize.height, radians);
    }

    public static FSize getSizeOfRotatedRectangleByDegrees(float rectangleWidth, float rectangleHeight, float degrees) {
        float radians = degrees * ((float)Math.PI / 180);
        return Utils.getSizeOfRotatedRectangleByRadians(rectangleWidth, rectangleHeight, radians);
    }

    public static FSize getSizeOfRotatedRectangleByRadians(float rectangleWidth, float rectangleHeight, float radians) {
        return FSize.getInstance(Math.abs(rectangleWidth * (float)Math.cos(radians)) + Math.abs(rectangleHeight * (float)Math.sin(radians)), Math.abs(rectangleWidth * (float)Math.sin(radians)) + Math.abs(rectangleHeight * (float)Math.cos(radians)));
    }

    public static int getSDKInt() {
        return Build.VERSION.SDK_INT;
    }

    public static double granularity(float range, int labelCount) {
        double intervalMagnitude;
        double rawInterval = range / (float)labelCount;
        double interval = Utils.roundToNextSignificant(rawInterval);
        int intervalSigDigit = (int)(interval / (intervalMagnitude = (double)Utils.roundToNextSignificant(Math.pow(10.0, (int)Math.log10(interval)))));
        if (intervalSigDigit > 5) {
            interval = Math.floor(10.0 * intervalMagnitude);
        }
        return interval * 0.1;
    }

    static {
        mMinimumFlingVelocity = 50;
        mMaximumFlingVelocity = 8000;
        mCalcTextHeightRect = new Rect();
        mCalcTextSizeRect = new Rect();
        POW_10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        mDrawTextRectBuffer = new Rect();
        mFontMetricsBuffer = new Paint.FontMetrics();
    }
}

