/*
 * Decompiled with CFR 0.152.
 */
package com.github.testpress.mikephil.charting.data;

import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.Parcelable;
import com.github.testpress.mikephil.charting.data.BaseEntry;

public class Entry
extends BaseEntry
implements Parcelable {
    private float x = 0.0f;
    public static final Parcelable.Creator<Entry> CREATOR = new Parcelable.Creator<Entry>(){

        public Entry createFromParcel(Parcel source) {
            return new Entry(source);
        }

        public Entry[] newArray(int size) {
            return new Entry[size];
        }
    };

    public Entry() {
    }

    public Entry(float x, float y) {
        super(y);
        this.x = x;
    }

    public Entry(float x, float y, Object data) {
        super(y, data);
        this.x = x;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public Entry copy() {
        Entry e = new Entry(this.x, this.getY(), this.getData());
        return e;
    }

    public boolean equalTo(Entry e) {
        if (e == null) {
            return false;
        }
        if (e.getData() != this.getData()) {
            return false;
        }
        if (Math.abs(e.x - this.x) > 1.0E-6f) {
            return false;
        }
        return !(Math.abs(e.getY() - this.getY()) > 1.0E-6f);
    }

    public String toString() {
        return "Entry, x: " + this.x + " y (sum): " + this.getY();
    }

    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.x);
        dest.writeFloat(this.getY());
        if (this.getData() != null) {
            if (!(this.getData() instanceof Parcelable)) throw new ParcelFormatException("Cannot parcel an Entry with non-parcelable data");
            dest.writeInt(1);
            dest.writeParcelable((Parcelable)this.getData(), flags);
            return;
        } else {
            dest.writeInt(0);
        }
    }

    protected Entry(Parcel in) {
        this.x = in.readFloat();
        this.setY(in.readFloat());
        if (in.readInt() == 1) {
            this.setData(in.readParcelable(Object.class.getClassLoader()));
        }
    }
}

