/*
 * Decompiled with CFR 0.152.
 */
package com.github.testpress.mikephil.charting.animation;

import com.github.testpress.mikephil.charting.animation.EasingFunction;

public class Easing {
    public static EasingFunction getEasingFunctionFromOption(EasingOption easing) {
        switch (easing) {
            default: {
                return EasingFunctions.Linear;
            }
            case EaseInQuad: {
                return EasingFunctions.EaseInQuad;
            }
            case EaseOutQuad: {
                return EasingFunctions.EaseOutQuad;
            }
            case EaseInOutQuad: {
                return EasingFunctions.EaseInOutQuad;
            }
            case EaseInCubic: {
                return EasingFunctions.EaseInCubic;
            }
            case EaseOutCubic: {
                return EasingFunctions.EaseOutCubic;
            }
            case EaseInOutCubic: {
                return EasingFunctions.EaseInOutCubic;
            }
            case EaseInQuart: {
                return EasingFunctions.EaseInQuart;
            }
            case EaseOutQuart: {
                return EasingFunctions.EaseOutQuart;
            }
            case EaseInOutQuart: {
                return EasingFunctions.EaseInOutQuart;
            }
            case EaseInSine: {
                return EasingFunctions.EaseInSine;
            }
            case EaseOutSine: {
                return EasingFunctions.EaseOutSine;
            }
            case EaseInOutSine: {
                return EasingFunctions.EaseInOutSine;
            }
            case EaseInExpo: {
                return EasingFunctions.EaseInExpo;
            }
            case EaseOutExpo: {
                return EasingFunctions.EaseOutExpo;
            }
            case EaseInOutExpo: {
                return EasingFunctions.EaseInOutExpo;
            }
            case EaseInCirc: {
                return EasingFunctions.EaseInCirc;
            }
            case EaseOutCirc: {
                return EasingFunctions.EaseOutCirc;
            }
            case EaseInOutCirc: {
                return EasingFunctions.EaseInOutCirc;
            }
            case EaseInElastic: {
                return EasingFunctions.EaseInElastic;
            }
            case EaseOutElastic: {
                return EasingFunctions.EaseOutElastic;
            }
            case EaseInOutElastic: {
                return EasingFunctions.EaseInOutElastic;
            }
            case EaseInBack: {
                return EasingFunctions.EaseInBack;
            }
            case EaseOutBack: {
                return EasingFunctions.EaseOutBack;
            }
            case EaseInOutBack: {
                return EasingFunctions.EaseInOutBack;
            }
            case EaseInBounce: {
                return EasingFunctions.EaseInBounce;
            }
            case EaseOutBounce: {
                return EasingFunctions.EaseOutBounce;
            }
            case EaseInOutBounce: 
        }
        return EasingFunctions.EaseInOutBounce;
    }

    private static class EasingFunctions {
        public static final EasingFunction Linear = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                return input;
            }
        };
        public static final EasingFunction EaseInQuad = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                return input * input;
            }
        };
        public static final EasingFunction EaseOutQuad = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                return -input * (input - 2.0f);
            }
        };
        public static final EasingFunction EaseInOutQuad = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                float position = input / 0.5f;
                if (position < 1.0f) {
                    return 0.5f * position * position;
                }
                return -0.5f * ((position -= 1.0f) * (position - 2.0f) - 1.0f);
            }
        };
        public static final EasingFunction EaseInCubic = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                return input * input * input;
            }
        };
        public static final EasingFunction EaseOutCubic = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                return (input -= 1.0f) * input * input + 1.0f;
            }
        };
        public static final EasingFunction EaseInOutCubic = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                float position = input / 0.5f;
                if (position < 1.0f) {
                    return 0.5f * position * position * position;
                }
                return 0.5f * ((position -= 2.0f) * position * position + 2.0f);
            }
        };
        public static final EasingFunction EaseInQuart = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                return input * input * input * input;
            }
        };
        public static final EasingFunction EaseOutQuart = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                return -((input -= 1.0f) * input * input * input - 1.0f);
            }
        };
        public static final EasingFunction EaseInOutQuart = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                float position = input / 0.5f;
                if (position < 1.0f) {
                    return 0.5f * position * position * position * position;
                }
                return -0.5f * ((position -= 2.0f) * position * position * position - 2.0f);
            }
        };
        public static final EasingFunction EaseInSine = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                return -((float)Math.cos((double)input * 1.5707963267948966)) + 1.0f;
            }
        };
        public static final EasingFunction EaseOutSine = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                return (float)Math.sin((double)input * 1.5707963267948966);
            }
        };
        public static final EasingFunction EaseInOutSine = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                return -0.5f * ((float)Math.cos(Math.PI * (double)input) - 1.0f);
            }
        };
        public static final EasingFunction EaseInExpo = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                return input == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * (input - 1.0f));
            }
        };
        public static final EasingFunction EaseOutExpo = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                return input == 1.0f ? 1.0f : -((float)Math.pow(2.0, -10.0f * (input + 1.0f)));
            }
        };
        public static final EasingFunction EaseInOutExpo = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                if (input == 0.0f) {
                    return 0.0f;
                }
                if (input == 1.0f) {
                    return 1.0f;
                }
                float position = input / 0.5f;
                if (position < 1.0f) {
                    return 0.5f * (float)Math.pow(2.0, 10.0f * (position - 1.0f));
                }
                return 0.5f * (-((float)Math.pow(2.0, -10.0f * (position -= 1.0f))) + 2.0f);
            }
        };
        public static final EasingFunction EaseInCirc = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                return -((float)Math.sqrt(1.0f - input * input) - 1.0f);
            }
        };
        public static final EasingFunction EaseOutCirc = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                return (float)Math.sqrt(1.0f - (input -= 1.0f) * input);
            }
        };
        public static final EasingFunction EaseInOutCirc = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                float position = input / 0.5f;
                if (position < 1.0f) {
                    return -0.5f * ((float)Math.sqrt(1.0f - position * position) - 1.0f);
                }
                return 0.5f * ((float)Math.sqrt(1.0f - (position -= 2.0f) * position) + 1.0f);
            }
        };
        public static final EasingFunction EaseInElastic = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                if (input == 0.0f) {
                    return 0.0f;
                }
                float position = input;
                if (position == 1.0f) {
                    return 1.0f;
                }
                float p = 0.3f;
                float s = p / ((float)Math.PI * 2) * (float)Math.asin(1.0);
                return -((float)Math.pow(2.0, 10.0f * (position -= 1.0f)) * (float)Math.sin((double)(position - s) * (Math.PI * 2) / (double)p));
            }
        };
        public static final EasingFunction EaseOutElastic = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                if (input == 0.0f) {
                    return 0.0f;
                }
                float position = input;
                if (position == 1.0f) {
                    return 1.0f;
                }
                float p = 0.3f;
                float s = p / ((float)Math.PI * 2) * (float)Math.asin(1.0);
                return (float)Math.pow(2.0, -10.0f * position) * (float)Math.sin((double)(position - s) * (Math.PI * 2) / (double)p) + 1.0f;
            }
        };
        public static final EasingFunction EaseInOutElastic = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                if (input == 0.0f) {
                    return 0.0f;
                }
                float position = input / 0.5f;
                if (position == 2.0f) {
                    return 1.0f;
                }
                float p = 0.45000002f;
                float s = p / ((float)Math.PI * 2) * (float)Math.asin(1.0);
                if (position < 1.0f) {
                    return -0.5f * ((float)Math.pow(2.0, 10.0f * (position -= 1.0f)) * (float)Math.sin((double)(position * 1.0f - s) * (Math.PI * 2) / (double)p));
                }
                return (float)Math.pow(2.0, -10.0f * (position -= 1.0f)) * (float)Math.sin((double)(position * 1.0f - s) * (Math.PI * 2) / (double)p) * 0.5f + 1.0f;
            }
        };
        public static final EasingFunction EaseInBack = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                float s = 1.70158f;
                float position = input;
                return position * position * (2.70158f * position - 1.70158f);
            }
        };
        public static final EasingFunction EaseOutBack = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                float s = 1.70158f;
                float position = input;
                return (position -= 1.0f) * position * (2.70158f * position + 1.70158f) + 1.0f;
            }
        };
        public static final EasingFunction EaseInOutBack = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                float s = 1.70158f;
                float position = input / 0.5f;
                if (position < 1.0f) {
                    return 0.5f * (position * position * (((s *= 1.525f) + 1.0f) * position - s));
                }
                return 0.5f * ((position -= 2.0f) * position * (((s *= 1.525f) + 1.0f) * position + s) + 2.0f);
            }
        };
        public static final EasingFunction EaseInBounce = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                return 1.0f - EaseOutBounce.getInterpolation(1.0f - input);
            }
        };
        public static final EasingFunction EaseOutBounce = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                float position = input;
                if (position < 0.36363637f) {
                    return 7.5625f * position * position;
                }
                if (position < 0.72727275f) {
                    return 7.5625f * (position -= 0.54545456f) * position + 0.75f;
                }
                if (position < 0.90909094f) {
                    return 7.5625f * (position -= 0.8181818f) * position + 0.9375f;
                }
                return 7.5625f * (position -= 0.95454544f) * position + 0.984375f;
            }
        };
        public static final EasingFunction EaseInOutBounce = new EasingFunction(){

            @Override
            public float getInterpolation(float input) {
                if (input < 0.5f) {
                    return EaseInBounce.getInterpolation(input * 2.0f) * 0.5f;
                }
                return EaseOutBounce.getInterpolation(input * 2.0f - 1.0f) * 0.5f + 0.5f;
            }
        };

        private EasingFunctions() {
        }
    }

    public static enum EasingOption {
        Linear,
        EaseInQuad,
        EaseOutQuad,
        EaseInOutQuad,
        EaseInCubic,
        EaseOutCubic,
        EaseInOutCubic,
        EaseInQuart,
        EaseOutQuart,
        EaseInOutQuart,
        EaseInSine,
        EaseOutSine,
        EaseInOutSine,
        EaseInExpo,
        EaseOutExpo,
        EaseInOutExpo,
        EaseInCirc,
        EaseOutCirc,
        EaseInOutCirc,
        EaseInElastic,
        EaseOutElastic,
        EaseInOutElastic,
        EaseInBack,
        EaseOutBack,
        EaseInOutBack,
        EaseInBounce,
        EaseOutBounce,
        EaseInOutBounce;

    }
}

