/*
 * Decompiled with CFR 0.152.
 */
package net.christophschubert.cp.testcontainers.util;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.lifecycle.Startables;

public class TestContainerUtils {
    public static void startAll(Startable ... containers) {
        try {
            Startables.deepStart(Arrays.stream(containers)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            String msg = String.format("Error starting up %s", Arrays.asList(containers));
            throw new RuntimeException(msg, e.getCause());
        }
    }

    public static void prettyPrintEnvs(GenericContainer<?> c) {
        c.getEnvMap().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> System.out.printf("%s: '%s'%n", e.getKey(), e.getValue()));
    }
}

