/*
 * Decompiled with CFR 0.152.
 */
package net.christophschubert.cp.testcontainers;

import net.christophschubert.cp.testcontainers.CPTestContainer;
import net.christophschubert.cp.testcontainers.SchemaRegistryContainer;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

public class RestProxyContainer
extends CPTestContainer<RestProxyContainer> {
    static final int defaultPort = 8082;

    RestProxyContainer(DockerImageName dockerImageName, KafkaContainer bootstrap, Network network) {
        super(dockerImageName, bootstrap, network, 8082, "KAFKA_REST");
        this.withEnv("KAFKA_REST_HOST_NAME", "restproxy");
        this.withEnv("KAFKA_REST_BOOTSTRAP_SERVERS", RestProxyContainer.getInternalBootstrap(bootstrap));
        this.withEnv("KAFKA_REST_LISTENERS", this.getHttpPortListener());
    }

    public RestProxyContainer withSchemaRegistry(SchemaRegistryContainer schemaRegistry) {
        this.withProperty("schema.registry.url", schemaRegistry.getInternalBaseUrl());
        this.dependsOn(new Startable[]{schemaRegistry});
        return this;
    }

    @Override
    public CPTestContainer<RestProxyContainer> withLogLevel(String logLevel) {
        return this;
    }
}

